/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.test.security.context.support;

import com.c4_soft.oauth2.rfc7519.JwtClaimSet;
import com.c4_soft.springaddons.test.security.context.support.StringAttribute;
import com.c4_soft.springaddons.test.security.context.support.StringAttributeParserSupport;
import com.c4_soft.springaddons.test.security.support.jwt.JwtAuthenticationTokenTestingBuilder;
import com.c4_soft.springaddons.test.security.support.missingpublicapi.JwtBuilder;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AliasFor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.security.test.context.support.TestExecutionEvent;
import org.springframework.security.test.context.support.WithSecurityContext;
import org.springframework.security.test.context.support.WithSecurityContextFactory;
import org.springframework.util.StringUtils;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Inherited
@Documented
@WithSecurityContext(factory=Factory.class)
public @interface WithMockJwt {
    @AliasFor(value="authorities")
    public String[] value() default {};

    @AliasFor(value="value")
    public String[] authorities() default {};

    public StringAttribute[] claims() default {};

    public StringAttribute[] headers() default {};

    @AliasFor(value="subject")
    public String name() default "";

    @AliasFor(value="name")
    public String subject() default "";

    public String[] scopes() default {};

    public String tokenValue() default "";

    @AliasFor(annotation=WithSecurityContext.class)
    public TestExecutionEvent setupBefore() default TestExecutionEvent.TEST_METHOD;

    public static final class Factory
    implements WithSecurityContextFactory<WithMockJwt> {
        private final StringAttributeParserSupport parsingSupport = new StringAttributeParserSupport();
        private final Converter<Jwt, Collection<GrantedAuthority>> authoritiesConverter;

        @Autowired
        public Factory(Converter<Jwt, Collection<GrantedAuthority>> authoritiesConverter) {
            this.authoritiesConverter = authoritiesConverter;
        }

        public SecurityContext createSecurityContext(WithMockJwt annotation) {
            SecurityContext context = SecurityContextHolder.createEmptyContext();
            context.setAuthentication((Authentication)this.authentication(annotation));
            return context;
        }

        public JwtAuthenticationToken authentication(WithMockJwt annotation) {
            String scopes;
            JwtAuthenticationTokenTestingBuilder authenticationBuilder = (JwtAuthenticationTokenTestingBuilder)new JwtAuthenticationTokenTestingBuilder(this.authoritiesConverter).token(jwt -> ((JwtBuilder)jwt.headers(headers -> headers.putAll(this.parsingSupport.parse(annotation.headers())))).claims(claims -> this.parsingSupport.parse(annotation.claims()).forEach((arg_0, arg_1) -> ((JwtClaimSet.Builder)claims).claim(arg_0, arg_1))));
            if (StringUtils.hasLength((String)annotation.tokenValue())) {
                authenticationBuilder.token(jwt -> jwt.tokenValue(annotation.tokenValue()));
            }
            if (StringUtils.hasLength((String)annotation.name())) {
                authenticationBuilder.name(annotation.name());
            }
            if (StringUtils.hasLength((String)(scopes = Stream.of(annotation.scopes()).collect(Collectors.joining(" "))))) {
                authenticationBuilder.token(jwt -> jwt.claim("scope", scopes));
            }
            if (annotation.authorities().length > 0) {
                authenticationBuilder.authorities(annotation.authorities());
            }
            return authenticationBuilder.build();
        }
    }
}

