/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.test.security.context.support;

import com.c4_soft.springaddons.test.security.context.support.AttributeValueParser;
import com.c4_soft.springaddons.test.security.context.support.StringAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StringAttributeParserSupport {
    private final Map<Class<? extends AttributeValueParser<String, ?>>, AttributeValueParser<String, ?>> parsers = new HashMap();
    private static BinaryOperator<Collection<Object>> SET_ACCUMULATOR = (v1, v2) -> {
        HashSet all = new HashSet(v1.size() + v2.size());
        all.addAll(v1);
        all.addAll(v2);
        return all;
    };
    private static BinaryOperator<Collection<Object>> LIST_ACCUMULATOR = (v1, v2) -> {
        ArrayList all = new ArrayList(v1.size() + v2.size());
        all.addAll(v1);
        all.addAll(v2);
        return all;
    };
    private static BinaryOperator<Map<Object, Object>> MAP_ACCUMULATOR = (v1, v2) -> {
        HashMap all = new HashMap(v1.size() + v2.size());
        all.putAll(v1);
        all.putAll(v2);
        return all;
    };

    private AttributeValueParser<String, ?> getParser(Class<? extends AttributeValueParser<String, ?>> parserClass) {
        if (!this.parsers.containsKey(parserClass)) {
            this.register(parserClass);
        }
        return this.parsers.get(parserClass);
    }

    private AttributeValueParser<String, ?> register(Class<? extends AttributeValueParser<String, ?>> parserClass) {
        try {
            AttributeValueParser<String, ?> parser = parserClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.parsers.put(parserClass, parser);
            return parser;
        }
        catch (Exception e) {
            throw new RuntimeException("Missing public no-arg constructor on " + parserClass.getName());
        }
    }

    private ParsedAttribute<?> parse(StringAttribute stringAttribute) {
        return new ParsedAttribute(stringAttribute.name(), this.getParser(stringAttribute.parser()).parse(stringAttribute.value()));
    }

    public Map<String, Object> parse(StringAttribute ... properties) {
        return Stream.of(properties).map(this::parse).collect(Collectors.toMap(ParsedAttribute::getName, ParsedAttribute::getValue, (v1, v2) -> {
            if (!(v1 instanceof Collection) || !(v2 instanceof Collection)) {
                throw new UnsupportedOperationException("@StringAttribute values can be accumuleted only if instance of Collection");
            }
            if (v1 instanceof Map) {
                if (v2 instanceof Map) {
                    return MAP_ACCUMULATOR.apply((Map)v1, (Map)v2);
                }
                throw new UnsupportedOperationException("@StringAttribute \"Map\" values can only be accumulated with Maps");
            }
            if (v2 instanceof Map) {
                throw new UnsupportedOperationException("@StringAttribute \"Map\" values can only be accumulated with Maps");
            }
            if (v1 instanceof List) {
                return LIST_ACCUMULATOR.apply((List)v1, (Collection)v2);
            }
            return SET_ACCUMULATOR.apply((Collection)v1, (Collection)v2);
        }));
    }

    private static final class ParsedAttribute<T> {
        private final String name;
        private final T value;

        public ParsedAttribute(String name, T value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public T getValue() {
            return this.value;
        }
    }
}

