/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.server.resource.authentication;

import com.c4_soft.oauth2.rfc7662.IntrospectionClaimSet;
import com.c4_soft.springaddons.security.oauth2.server.resource.authentication.AbstractClaimSetAuthenticationManager;
import java.util.Map;
import java.util.Set;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.introspection.NimbusOpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;

public class IntrospectionClaimSetAuthenticationManager<T extends IntrospectionClaimSet>
extends AbstractClaimSetAuthenticationManager<T> {
    private final OpaqueTokenIntrospector introspectionClient;
    private final Converter<Map<String, Object>, T> typedClaimsExtractor;

    public IntrospectionClaimSetAuthenticationManager(String introspectionEdpoint, String introspectionUsername, String introspectionPassword, Converter<Map<String, Object>, T> typedClaimsExtractor, Converter<Map<String, Object>, Set<GrantedAuthority>> authoritiesConverter) {
        super(authoritiesConverter);
        this.introspectionClient = new NimbusOpaqueTokenIntrospector(introspectionEdpoint, introspectionUsername, introspectionPassword);
        this.typedClaimsExtractor = typedClaimsExtractor;
    }

    @Override
    protected T extractClaims(BearerTokenAuthenticationToken bearer) {
        OAuth2AuthenticatedPrincipal principal = this.introspectionClient.introspect(bearer.getToken());
        return (T)((IntrospectionClaimSet)this.typedClaimsExtractor.convert((Object)principal.getAttributes()));
    }
}

