/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.reactive.client;

import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SpringAddonsOauth2ServerRedirectStrategy
implements ServerRedirectStrategy {
    private final HttpStatus defaultStatus;

    public Mono<Void> sendRedirect(ServerWebExchange exchange, URI location) {
        return Mono.fromRunnable(() -> {
            ServerHttpResponse response = exchange.getResponse();
            HttpStatus status = Optional.ofNullable(exchange.getRequest().getHeaders().get((Object)"X-RESPONSE-STATUS")).map(Collection::stream).orElse(Stream.empty()).filter(StringUtils::hasLength).findAny().map(statusStr -> {
                try {
                    int statusCode = Integer.parseInt(statusStr);
                    return HttpStatus.valueOf((int)statusCode);
                }
                catch (NumberFormatException e) {
                    return HttpStatus.valueOf((String)statusStr.toUpperCase());
                }
            }).orElse(this.defaultStatus);
            response.setStatusCode((HttpStatusCode)status);
            response.getHeaders().setLocation(location);
        });
    }

    @Generated
    public SpringAddonsOauth2ServerRedirectStrategy(HttpStatus defaultStatus) {
        this.defaultStatus = defaultStatus;
    }
}

