/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter;

import com.c4_soft.springaddons.security.oidc.starter.LogoutRequestUriBuilder;
import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcClientProperties;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class SpringAddonsOAuth2LogoutRequestUriBuilder
implements LogoutRequestUriBuilder {
    private static final String OIDC_RP_INITIATED_LOGOUT_CONFIGURATION_ENTRY = "end_session_endpoint";
    private static final String OIDC_RP_INITIATED_LOGOUT_CLIENT_ID_REQUEST_PARAM = "client_id";
    private static final String OIDC_RP_INITIATED_LOGOUT_ID_TOKEN_HINT_REQUEST_PARAM = "id_token_hint";
    private static final String OIDC_RP_INITIATED_LOGOUT_POST_LOGOUT_URI_REQUEST_PARAM = "post_logout_redirect_uri";
    private final SpringAddonsOidcClientProperties clientProperties;

    @Override
    public Optional<String> getLogoutRequestUri(ClientRegistration clientRegistration, String idToken, Optional<URI> postLogoutUri) {
        Optional<SpringAddonsOidcClientProperties.OAuth2LogoutProperties> logoutProps = this.clientProperties.getLogoutProperties(clientRegistration.getRegistrationId());
        if (!logoutProps.map(SpringAddonsOidcClientProperties.OAuth2LogoutProperties::isEnabled).orElse(true).booleanValue()) {
            return postLogoutUri.map(URI::toString).filter(StringUtils::hasText);
        }
        URI logoutEndpointUri = this.getLogoutEndpointUri(logoutProps, clientRegistration).orElseThrow(() -> new MisconfiguredProviderException(clientRegistration.getRegistrationId()));
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)logoutEndpointUri);
        this.getIdTokenHintRequestParam(logoutProps).ifPresent(idTokenHintParamName -> {
            if (StringUtils.hasText((String)idToken)) {
                builder.queryParam(idTokenHintParamName, new Object[]{idToken});
            }
        });
        this.getClientIdRequestParam(logoutProps).ifPresent(clientIdParamName -> {
            if (StringUtils.hasText((String)clientRegistration.getClientId())) {
                builder.queryParam(clientIdParamName, new Object[]{clientRegistration.getClientId()});
            }
        });
        this.getPostLogoutUriRequestParam(logoutProps).ifPresent(postLogoutUriParamName -> postLogoutUri.map(URI::toString).filter(StringUtils::hasText).ifPresent(uri -> builder.queryParam(postLogoutUriParamName, new Object[]{postLogoutUri})));
        return Optional.of(builder.encode(StandardCharsets.UTF_8).build().toUriString());
    }

    @Override
    public Optional<String> getLogoutRequestUri(ClientRegistration clientRegistration, String idToken) {
        return this.getLogoutRequestUri(clientRegistration, idToken, Optional.of(this.clientProperties.getPostLogoutRedirectUri()));
    }

    public Optional<URI> getLogoutEndpointUri(Optional<SpringAddonsOidcClientProperties.OAuth2LogoutProperties> logoutProps, ClientRegistration clientRegistration) {
        if (logoutProps.isPresent()) {
            return logoutProps.flatMap(props -> props.isEnabled() ? Optional.ofNullable(((SpringAddonsOidcClientProperties.OAuth2LogoutProperties)logoutProps.get()).getUri()) : Optional.empty());
        }
        Map oidcConfig = clientRegistration.getProviderDetails().getConfigurationMetadata();
        return Optional.ofNullable(oidcConfig.get(OIDC_RP_INITIATED_LOGOUT_CONFIGURATION_ENTRY)).map(Object::toString).map(URI::create);
    }

    public Optional<String> getIdTokenHintRequestParam(Optional<SpringAddonsOidcClientProperties.OAuth2LogoutProperties> logoutProps) {
        if (logoutProps.isEmpty()) {
            return Optional.of(OIDC_RP_INITIATED_LOGOUT_ID_TOKEN_HINT_REQUEST_PARAM);
        }
        return logoutProps.get().getIdTokenHintRequestParam();
    }

    public Optional<String> getClientIdRequestParam(Optional<SpringAddonsOidcClientProperties.OAuth2LogoutProperties> logoutProps) {
        if (logoutProps.isEmpty()) {
            return Optional.of(OIDC_RP_INITIATED_LOGOUT_CLIENT_ID_REQUEST_PARAM);
        }
        return logoutProps.get().getClientIdRequestParam();
    }

    public Optional<String> getPostLogoutUriRequestParam(Optional<SpringAddonsOidcClientProperties.OAuth2LogoutProperties> logoutProps) {
        if (logoutProps.isEmpty()) {
            return Optional.of(OIDC_RP_INITIATED_LOGOUT_POST_LOGOUT_URI_REQUEST_PARAM);
        }
        return logoutProps.get().getPostLogoutUriRequestParam();
    }

    @Generated
    public SpringAddonsOidcClientProperties getClientProperties() {
        return this.clientProperties;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringAddonsOAuth2LogoutRequestUriBuilder)) {
            return false;
        }
        SpringAddonsOAuth2LogoutRequestUriBuilder other = (SpringAddonsOAuth2LogoutRequestUriBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SpringAddonsOidcClientProperties this$clientProperties = this.getClientProperties();
        SpringAddonsOidcClientProperties other$clientProperties = other.getClientProperties();
        return !(this$clientProperties == null ? other$clientProperties != null : !((Object)this$clientProperties).equals(other$clientProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpringAddonsOAuth2LogoutRequestUriBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SpringAddonsOidcClientProperties $clientProperties = this.getClientProperties();
        result = result * 59 + ($clientProperties == null ? 43 : ((Object)$clientProperties).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SpringAddonsOAuth2LogoutRequestUriBuilder(clientProperties=" + this.getClientProperties() + ")";
    }

    @Generated
    public SpringAddonsOAuth2LogoutRequestUriBuilder(SpringAddonsOidcClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    static final class MisconfiguredProviderException
    extends RuntimeException {
        private static final long serialVersionUID = -7076019485141231080L;

        public MisconfiguredProviderException(String clientRegistrationId) {
            super("OAuth2 client registration for %s RP-Initiated Logout is missconfigured: it is neither OIDC complient nor difiend in spring-addons properties".formatted(clientRegistrationId));
        }
    }
}

