/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.reactive.client;

import com.c4_soft.springaddons.security.oidc.starter.AdditionalParamsAuthorizationRequestCustomizer;
import com.c4_soft.springaddons.security.oidc.starter.CompositeOAuth2AuthorizationRequestCustomizer;
import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcClientProperties;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestCustomizers;
import org.springframework.security.oauth2.client.web.server.DefaultServerOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class SpringAddonsServerOAuth2AuthorizationRequestResolver
implements ServerOAuth2AuthorizationRequestResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringAddonsServerOAuth2AuthorizationRequestResolver.class);
    private static final Pattern authorizationRequestPattern = Pattern.compile("\\/oauth2\\/authorization\\/([^\\/]+)");
    private final URI clientUri;
    private final Map<String, DefaultServerOAuth2AuthorizationRequestResolver> delegates;
    private final ServerWebExchangeMatcher authorizationRequestMatcher;

    public SpringAddonsServerOAuth2AuthorizationRequestResolver(OAuth2ClientProperties bootClientProperties, ReactiveClientRegistrationRepository clientRegistrationRepository, SpringAddonsOidcClientProperties addonsClientProperties) {
        this.clientUri = addonsClientProperties.getClientUri();
        this.authorizationRequestMatcher = new PathPatternParserServerWebExchangeMatcher("/oauth2/authorization/{registrationId}");
        this.delegates = bootClientProperties.getRegistration().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, registrationEntry -> {
            CompositeOAuth2AuthorizationRequestCustomizer requestCustomizer = new CompositeOAuth2AuthorizationRequestCustomizer(new Consumer[0]);
            List<SpringAddonsOidcClientProperties.RequestParam> additionalProperties = addonsClientProperties.getAuthorizationRequestParams().getOrDefault(registrationEntry.getKey(), List.of());
            if (additionalProperties.size() > 0) {
                requestCustomizer.addCustomizer(new AdditionalParamsAuthorizationRequestCustomizer(additionalProperties));
            }
            if (addonsClientProperties.isPkceForced()) {
                requestCustomizer.addCustomizer(OAuth2AuthorizationRequestCustomizers.withPkce());
            }
            DefaultServerOAuth2AuthorizationRequestResolver delegate = new DefaultServerOAuth2AuthorizationRequestResolver(clientRegistrationRepository);
            delegate.setAuthorizationRequestCustomizer((Consumer)requestCustomizer);
            return delegate;
        }));
    }

    private Mono<WebSession> savePostLoginUrisInSession(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        HttpHeaders headers = request.getHeaders();
        MultiValueMap params = request.getQueryParams();
        return exchange.getSession().map(session -> {
            Optional.ofNullable(Optional.ofNullable(headers.getFirst("X-POST-LOGIN-SUCCESS-URI")).orElse(Optional.ofNullable((String)params.getFirst((Object)"post_login_success_uri")).orElse(null))).filter(StringUtils::hasText).map(URI::create).ifPresent(postLoginSuccessUri -> session.getAttributes().put("post_login_success_uri", postLoginSuccessUri));
            Optional.ofNullable(Optional.ofNullable(headers.getFirst("X-POST-LOGIN-FAILURE-URI")).orElse(Optional.ofNullable((String)params.getFirst((Object)"post_login_failure_uri")).orElse(null))).filter(StringUtils::hasText).map(URI::create).ifPresent(postLoginFailureUri -> session.getAttributes().put("post_login_failure_uri", postLoginFailureUri));
            return session;
        });
    }

    private OAuth2AuthorizationRequest postProcess(OAuth2AuthorizationRequest request) {
        OAuth2AuthorizationRequest.Builder modified = OAuth2AuthorizationRequest.from((OAuth2AuthorizationRequest)request);
        URI original = URI.create(request.getRedirectUri());
        String redirectUri = UriComponentsBuilder.fromUri((URI)this.clientUri).path(original.getPath()).query(original.getQuery()).fragment(original.getFragment()).build().toString();
        modified.redirectUri(redirectUri);
        log.debug("Changed OAuth2AuthorizationRequest redirectUri from {} to {}", (Object)original, (Object)redirectUri);
        return modified.build();
    }

    public Mono<OAuth2AuthorizationRequest> resolve(ServerWebExchange exchange) {
        return this.authorizationRequestMatcher.matches(exchange).filter(matchResult -> matchResult.isMatch()).map(ServerWebExchangeMatcher.MatchResult::getVariables).map(variables -> variables.get("registrationId")).cast(String.class).flatMap(clientRegistrationId -> this.resolve(exchange, (String)clientRegistrationId));
    }

    public Mono<OAuth2AuthorizationRequest> resolve(ServerWebExchange exchange, String clientRegistrationId) {
        DefaultServerOAuth2AuthorizationRequestResolver delegate = this.delegates.get(clientRegistrationId);
        return this.savePostLoginUrisInSession(exchange).then(delegate.resolve(exchange, clientRegistrationId).map(this::postProcess));
    }

    static String resolveRegistrationId(ServerWebExchange exchange) {
        String requestPath = Optional.ofNullable(exchange.getRequest()).map(ServerHttpRequest::getPath).map(Object::toString).orElse("");
        return SpringAddonsServerOAuth2AuthorizationRequestResolver.resolveRegistrationId(requestPath);
    }

    static String resolveRegistrationId(String requestPath) {
        Matcher matcher = authorizationRequestPattern.matcher(requestPath);
        return matcher.matches() ? matcher.group(1) : null;
    }
}

