/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.synchronised;

import com.c4_soft.springaddons.security.oidc.OpenidClaimSet;
import com.c4_soft.springaddons.security.oidc.starter.ByIssuerOpenidProviderPropertiesResolver;
import com.c4_soft.springaddons.security.oidc.starter.ClaimSetAuthoritiesConverter;
import com.c4_soft.springaddons.security.oidc.starter.ConfigurableClaimSetAuthoritiesConverter;
import com.c4_soft.springaddons.security.oidc.starter.OpenidProviderPropertiesResolver;
import com.c4_soft.springaddons.security.oidc.starter.properties.NotAConfiguredOpenidProviderException;
import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultGrantedAuthoritiesMapperCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultJwtAbstractAuthenticationTokenConverterCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultOpaqueTokenAuthenticationConverterCondition;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.resourceserver.JwtAbstractAuthenticationTokenConverter;
import java.sql.Date;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.core.oidc.user.OidcUserAuthority;
import org.springframework.security.oauth2.core.user.OAuth2UserAuthority;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionAuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenAuthenticationConverter;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@AutoConfiguration
@ImportAutoConfiguration(value={SpringAddonsOidcProperties.class})
public class SpringAddonsOidcBeans {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringAddonsOidcBeans.class);

    @ConditionalOnMissingBean
    @Bean
    OpenidProviderPropertiesResolver openidProviderPropertiesResolver(SpringAddonsOidcProperties addonsProperties) {
        log.debug("Building default OpenidProviderPropertiesResolver with: {}", addonsProperties.getOps());
        return new ByIssuerOpenidProviderPropertiesResolver(addonsProperties);
    }

    @ConditionalOnMissingBean
    @Bean
    ClaimSetAuthoritiesConverter authoritiesConverter(OpenidProviderPropertiesResolver authoritiesMappingPropertiesProvider) {
        return new ConfigurableClaimSetAuthoritiesConverter(authoritiesMappingPropertiesProvider);
    }

    @Conditional(value={DefaultJwtAbstractAuthenticationTokenConverterCondition.class})
    @Bean
    JwtAbstractAuthenticationTokenConverter jwtAuthenticationConverter(Converter<Map<String, Object>, Collection<? extends GrantedAuthority>> authoritiesConverter, OpenidProviderPropertiesResolver opPropertiesResolver) {
        return jwt -> new JwtAuthenticationToken(jwt, (Collection)authoritiesConverter.convert((Object)jwt.getClaims()), new OpenidClaimSet(jwt.getClaims(), opPropertiesResolver.resolve(jwt.getClaims()).orElseThrow(() -> new NotAConfiguredOpenidProviderException(jwt.getClaims())).getUsernameClaim()).getName());
    }

    @Conditional(value={DefaultOpaqueTokenAuthenticationConverterCondition.class})
    @Bean
    OpaqueTokenAuthenticationConverter introspectionAuthenticationConverter(Converter<Map<String, Object>, Collection<? extends GrantedAuthority>> authoritiesConverter, SpringAddonsOidcProperties addonsProperties, OAuth2ResourceServerProperties resourceServerProperties) {
        return (introspectedToken, authenticatedPrincipal) -> {
            Object iatClaim = authenticatedPrincipal.getAttribute("iat");
            Object expClaim = authenticatedPrincipal.getAttribute("exp");
            return new BearerTokenAuthentication((OAuth2AuthenticatedPrincipal)new OAuth2IntrospectionAuthenticatedPrincipal(new OpenidClaimSet(authenticatedPrincipal.getAttributes(), addonsProperties.getOps().stream().filter(openidProvider -> resourceServerProperties.getOpaquetoken().getIntrospectionUri().contains(openidProvider.getIss().toString())).findAny().orElse(addonsProperties.getOps().get(0)).getUsernameClaim()).getName(), authenticatedPrincipal.getAttributes(), authenticatedPrincipal.getAuthorities()), new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, introspectedToken, this.toInstant(iatClaim), this.toInstant(expClaim)), (Collection)authoritiesConverter.convert((Object)authenticatedPrincipal.getAttributes()));
        };
    }

    private final Instant toInstant(Object claim) {
        if (claim == null) {
            return null;
        }
        if (claim instanceof Instant) {
            Instant i = (Instant)claim;
            return i;
        }
        if (claim instanceof Date) {
            Date d = (Date)claim;
            return d.toInstant();
        }
        if (claim instanceof Integer) {
            Integer i = (Integer)claim;
            return Instant.ofEpochSecond(i.longValue());
        }
        if (claim instanceof Long) {
            Long l = (Long)claim;
            return Instant.ofEpochSecond(l);
        }
        return null;
    }

    @Conditional(value={DefaultGrantedAuthoritiesMapperCondition.class})
    @Bean
    GrantedAuthoritiesMapper grantedAuthoritiesMapper(Converter<Map<String, Object>, Collection<? extends GrantedAuthority>> authoritiesConverter) {
        return authorities -> {
            HashSet mappedAuthorities = new HashSet();
            authorities.forEach(authority -> {
                if (authority instanceof OidcUserAuthority) {
                    OidcUserAuthority oidcAuth = (OidcUserAuthority)authority;
                    mappedAuthorities.addAll((Collection)authoritiesConverter.convert((Object)oidcAuth.getIdToken().getClaims()));
                } else if (authority instanceof OAuth2UserAuthority) {
                    OAuth2UserAuthority oauth2Auth = (OAuth2UserAuthority)authority;
                    mappedAuthorities.addAll((Collection)authoritiesConverter.convert((Object)oauth2Auth.getAttributes()));
                }
            });
            return mappedAuthorities;
        };
    }
}

