/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.reactive.client;

import com.c4_soft.springaddons.security.oidc.starter.LogoutRequestUriBuilder;
import com.c4_soft.springaddons.security.oidc.starter.SpringAddonsOAuth2LogoutRequestUriBuilder;
import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.CookieCsrfCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultAuthenticationSuccessHandlerCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.configuration.IsClientWithLoginCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.configuration.IsNotServlet;
import com.c4_soft.springaddons.security.oidc.starter.reactive.ReactiveConfigurationSupport;
import com.c4_soft.springaddons.security.oidc.starter.reactive.ReactiveSpringAddonsOidcBeans;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.ClientAuthorizeExchangeSpecPostProcessor;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.ClientReactiveHttpSecurityPostProcessor;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.SpringAddonsOauth2ServerAuthenticationFailureHandler;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.SpringAddonsOauth2ServerAuthenticationSuccessHandler;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.SpringAddonsOauth2ServerRedirectStrategy;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.SpringAddonsServerLogoutSuccessHandler;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.SpringAddonsServerOAuth2AuthorizationRequestResolver;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizationRequestResolver;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.security.web.server.authentication.RedirectServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authentication.ServerAuthenticationFailureHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.security.web.server.util.matcher.OrServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.web.server.WebFilter;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@Conditional(value={IsClientWithLoginCondition.class, IsNotServlet.class})
@EnableWebFluxSecurity
@AutoConfiguration
@ImportAutoConfiguration(value={ReactiveSpringAddonsOidcBeans.class})
public class ReactiveSpringAddonsOidcClientWithLoginBeans {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactiveSpringAddonsOidcClientWithLoginBeans.class);

    @Order(value=0x7FFFFFFE)
    @Bean
    SecurityWebFilterChain clientFilterChain(ServerHttpSecurity http, ServerProperties serverProperties, SpringAddonsOidcProperties addonsProperties, ServerOAuth2AuthorizationRequestResolver authorizationRequestResolver, PreAuthorizationCodeServerRedirectStrategy preAuthorizationCodeRedirectStrategy, Optional<ServerAuthenticationSuccessHandler> authenticationSuccessHandler, Optional<ServerAuthenticationFailureHandler> authenticationFailureHandler, ServerLogoutSuccessHandler logoutSuccessHandler, ClientAuthorizeExchangeSpecPostProcessor authorizePostProcessor, ClientReactiveHttpSecurityPostProcessor httpPostProcessor, Optional<ServerLogoutHandler> logoutHandler, Customizer<ServerHttpSecurity.OidcLogoutSpec> oidcLogoutCustomizer) throws Exception {
        List<ServerWebExchangeMatcher> clientRoutes = addonsProperties.getClient().getSecurityMatchers().stream().map(PathPatternParserServerWebExchangeMatcher::new).map(ServerWebExchangeMatcher.class::cast).toList();
        log.info("Applying client OAuth2 configuration for: {}", addonsProperties.getClient().getSecurityMatchers());
        http.securityMatcher((ServerWebExchangeMatcher)new OrServerWebExchangeMatcher(clientRoutes));
        addonsProperties.getClient().getLoginPath().ifPresent(loginPath -> http.exceptionHandling(exceptionHandling -> exceptionHandling.authenticationEntryPoint((ServerAuthenticationEntryPoint)new RedirectServerAuthenticationEntryPoint(UriComponentsBuilder.fromUri((URI)addonsProperties.getClient().getClientUri()).path(loginPath).build().toString()))));
        http.oauth2Login(oauth2 -> {
            oauth2.authorizationRequestResolver(authorizationRequestResolver);
            oauth2.authorizationRedirectStrategy((ServerRedirectStrategy)preAuthorizationCodeRedirectStrategy);
            authenticationSuccessHandler.ifPresent(arg_0 -> ((ServerHttpSecurity.OAuth2LoginSpec)oauth2).authenticationSuccessHandler(arg_0));
            authenticationFailureHandler.ifPresent(arg_0 -> ((ServerHttpSecurity.OAuth2LoginSpec)oauth2).authenticationFailureHandler(arg_0));
        });
        http.logout(logout -> {
            logoutHandler.ifPresent(arg_0 -> ((ServerHttpSecurity.LogoutSpec)logout).logoutHandler(arg_0));
            logout.logoutSuccessHandler(logoutSuccessHandler);
        });
        if (addonsProperties.getClient().getBackChannelLogout().isEnabled()) {
            http.oidcLogout(logout -> logout.backChannel(Customizer.withDefaults()));
        }
        ReactiveConfigurationSupport.configureClient(http, serverProperties, addonsProperties.getClient(), authorizePostProcessor, httpPostProcessor);
        return http.build();
    }

    @ConditionalOnMissingBean
    @Bean
    LogoutRequestUriBuilder logoutRequestUriBuilder(SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsOAuth2LogoutRequestUriBuilder(addonsProperties.getClient());
    }

    @ConditionalOnMissingBean
    @Bean
    ServerLogoutSuccessHandler logoutSuccessHandler(LogoutRequestUriBuilder logoutUriBuilder, ReactiveClientRegistrationRepository clientRegistrationRepo, SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsServerLogoutSuccessHandler(logoutUriBuilder, clientRegistrationRepo, addonsProperties);
    }

    @ConditionalOnMissingBean
    @Bean
    ClientAuthorizeExchangeSpecPostProcessor clientAuthorizePostProcessor() {
        return spec -> spec.anyExchange().authenticated();
    }

    @ConditionalOnMissingBean
    @Bean
    ClientReactiveHttpSecurityPostProcessor clientHttpPostProcessor() {
        return serverHttpSecurity -> serverHttpSecurity;
    }

    @Conditional(value={CookieCsrfCondition.class})
    @ConditionalOnMissingBean(name={"csrfCookieWebFilter"})
    @Bean
    WebFilter csrfCookieWebFilter() {
        return (exchange, chain) -> {
            ((Mono)exchange.getAttributeOrDefault(CsrfToken.class.getName(), (Object)Mono.empty())).subscribe();
            return chain.filter(exchange);
        };
    }

    @ConditionalOnMissingBean
    @Bean
    ServerOAuth2AuthorizationRequestResolver authorizationRequestResolver(ReactiveClientRegistrationRepository clientRegistrationRepository, SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsServerOAuth2AuthorizationRequestResolver(clientRegistrationRepository, addonsProperties.getClient());
    }

    @ConditionalOnMissingBean
    @Bean
    PreAuthorizationCodeServerRedirectStrategy preAuthorizationCodeRedirectStrategy(SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsPreAuthorizationCodeServerRedirectStrategy(addonsProperties.getClient().getOauth2Redirections().getPreAuthorizationCode());
    }

    @Conditional(value={DefaultAuthenticationSuccessHandlerCondition.class})
    @Bean
    ServerAuthenticationSuccessHandler authenticationSuccessHandler(SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsOauth2ServerAuthenticationSuccessHandler(addonsProperties);
    }

    @Conditional(value={DefaultAuthenticationSuccessHandlerCondition.class})
    @Bean
    ServerAuthenticationFailureHandler authenticationFailureHandler(SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsOauth2ServerAuthenticationFailureHandler(addonsProperties);
    }

    @ConditionalOnMissingBean
    @Bean
    Customizer<ServerHttpSecurity.OidcLogoutSpec> oidcLogoutSpec() {
        return Customizer.withDefaults();
    }

    public static interface PreAuthorizationCodeServerRedirectStrategy
    extends ServerRedirectStrategy {
    }

    public static class SpringAddonsPreAuthorizationCodeServerRedirectStrategy
    extends SpringAddonsOauth2ServerRedirectStrategy
    implements PreAuthorizationCodeServerRedirectStrategy {
        public SpringAddonsPreAuthorizationCodeServerRedirectStrategy(HttpStatus defaultStatus) {
            super(defaultStatus);
        }
    }
}

