/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc;

import com.c4_soft.springaddons.security.oidc.UnparsableClaimException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public interface ClaimSet
extends Map<String, Object>,
Serializable {
    default public <T> T getByJsonPath(String jsonPath) {
        return (T)JsonPath.read((Object)this, (String)jsonPath, (Predicate[])new Predicate[0]);
    }

    default public String getAsString(String name) {
        Object claim = this.get(name);
        return claim == null ? null : claim.toString();
    }

    @Nullable
    default public Instant getAsInstant(String name) {
        Object claim = this.get(name);
        if (claim == null) {
            return null;
        }
        if (claim instanceof Long) {
            Long l = (Long)claim;
            return Instant.ofEpochSecond(l);
        }
        if (claim instanceof Instant) {
            Instant instant = (Instant)claim;
            return instant;
        }
        if (claim instanceof String) {
            String str = (String)claim;
            return Instant.parse(str);
        }
        throw new UnparsableClaimException("claim " + name + " is of unsupported type " + claim.getClass().getName());
    }

    @Nullable
    default public Set<String> getAsStringSet(String name) {
        Object claim = this.get(name);
        if (claim == null) {
            return null;
        }
        if (claim instanceof Collection) {
            Collection collection = (Collection)claim;
            return collection.stream().flatMap(o -> Stream.of(o.toString().split(" "))).collect(Collectors.toSet());
        }
        return Stream.of(claim.toString().split(" ")).collect(Collectors.toSet());
    }

    @Nullable
    default public URI getAsUri(String name) throws URISyntaxException {
        Object claim = this.get(name);
        if (claim == null) {
            return null;
        }
        if (claim instanceof URI) {
            URI uri = (URI)claim;
            return uri;
        }
        return new URI(claim.toString());
    }

    @Nullable
    default public Boolean getAsBoolean(String name) {
        Object claim = this.get(name);
        if (claim == null) {
            return null;
        }
        if (claim instanceof Boolean) {
            Boolean b = (Boolean)claim;
            return b;
        }
        return Boolean.valueOf(claim.toString());
    }

    default public ClaimSet claim(String claimName, String claimValue) {
        Assert.hasLength((String)claimName, (String)"claimName can't be empty");
        if (StringUtils.hasLength((String)claimValue)) {
            this.put(claimName, claimValue);
        } else {
            this.remove(claimName);
        }
        return this;
    }

    default public ClaimSet claim(String claimName, Collection<?> claimValue) {
        Assert.hasLength((String)claimName, (String)"claimName can't be empty");
        if (claimValue == null || claimValue.isEmpty()) {
            this.remove(claimName);
        } else {
            this.put(claimName, claimValue);
        }
        return this;
    }

    default public ClaimSet claim(String claimName, Object claimValue) {
        Assert.hasLength((String)claimName, (String)"claimName can't be empty");
        if (claimValue == null) {
            this.remove(claimName);
        } else {
            this.put(claimName, claimValue);
        }
        return this;
    }
}

