/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations.parameterized;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.junit.jupiter.params.converter.ConvertWith;
import org.junit.jupiter.params.converter.TypedArgumentConverter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@ConvertWith(value=AuthenticationArgumentProcessor.class)
public @interface ParameterizedOidcLogin {

    public static class AuthenticationArgumentProcessor
    extends TypedArgumentConverter<OAuth2AuthenticationToken, OAuth2AuthenticationToken> {
        protected AuthenticationArgumentProcessor() {
            super(OAuth2AuthenticationToken.class, OAuth2AuthenticationToken.class);
        }

        protected OAuth2AuthenticationToken convert(OAuth2AuthenticationToken source) {
            SecurityContextHolder.getContext().setAuthentication((Authentication)source);
            return source;
        }
    }
}

