/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test;

import com.c4_soft.springaddons.security.oidc.ModifiableClaimSet;
import com.c4_soft.springaddons.security.oidc.OpenidClaimSet;
import java.net.URL;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class OpenidClaimSetBuilder
extends ModifiableClaimSet {
    private static final long serialVersionUID = 8050195176203128543L;
    private String usernameClaim = "sub";

    public OpenidClaimSetBuilder() {
    }

    public OpenidClaimSetBuilder(Map<String, Object> ptivateClaims) {
        super(ptivateClaims);
    }

    public OpenidClaimSet build() {
        return new OpenidClaimSet((Map)((Object)this), this.usernameClaim);
    }

    public OpenidClaimSetBuilder usernameClaim(String usernameClaim) {
        this.usernameClaim = usernameClaim;
        return this;
    }

    public OpenidClaimSetBuilder acr(String acr) {
        return this.setIfNonEmpty("acr", acr);
    }

    public OpenidClaimSetBuilder amr(List<String> amr) {
        return this.setIfNonEmpty("amr", amr);
    }

    public OpenidClaimSetBuilder audience(List<String> audience) {
        return this.setIfNonEmpty("aud", audience);
    }

    public OpenidClaimSetBuilder authTime(Instant authTime) {
        return this.setIfNonEmpty("auth_time", authTime);
    }

    public OpenidClaimSetBuilder azp(String azp) {
        return this.setIfNonEmpty("azp", azp);
    }

    public OpenidClaimSetBuilder expiresAt(Instant expiresAt) {
        return this.setIfNonEmpty("exp", expiresAt);
    }

    public OpenidClaimSetBuilder issuedAt(Instant issuedAt) {
        return this.setIfNonEmpty("iat", issuedAt);
    }

    public OpenidClaimSetBuilder jwtId(String jti) {
        return this.setIfNonEmpty("jti", jti);
    }

    public OpenidClaimSetBuilder issuer(URL issuer) {
        return this.setIfNonEmpty("iss", issuer.toString());
    }

    public OpenidClaimSetBuilder nonce(String nonce) {
        return this.setIfNonEmpty("nonce", nonce);
    }

    public OpenidClaimSetBuilder notBefore(Instant nbf) {
        return this.setIfNonEmpty("nbf", nbf);
    }

    public OpenidClaimSetBuilder accessTokenHash(String atHash) {
        return this.setIfNonEmpty("at_hash", atHash);
    }

    public OpenidClaimSetBuilder authorizationCodeHash(String cHash) {
        return this.setIfNonEmpty("c_hash", cHash);
    }

    public OpenidClaimSetBuilder sessionState(String sessionState) {
        return this.setIfNonEmpty("session_state", sessionState);
    }

    public OpenidClaimSetBuilder subject(String subject) {
        return this.setIfNonEmpty("sub", subject);
    }

    public OpenidClaimSetBuilder name(String value) {
        return this.setIfNonEmpty("name", value);
    }

    public OpenidClaimSetBuilder givenName(String value) {
        return this.setIfNonEmpty("given_name", value);
    }

    public OpenidClaimSetBuilder familyName(String value) {
        return this.setIfNonEmpty("family_name", value);
    }

    public OpenidClaimSetBuilder middleName(String value) {
        return this.setIfNonEmpty("middle_name", value);
    }

    public OpenidClaimSetBuilder nickname(String value) {
        return this.setIfNonEmpty("nickname", value);
    }

    public OpenidClaimSetBuilder preferredUsername(String value) {
        return this.setIfNonEmpty("preferred_username", value);
    }

    public OpenidClaimSetBuilder profile(String value) {
        return this.setIfNonEmpty("profile", value);
    }

    public OpenidClaimSetBuilder picture(String value) {
        return this.setIfNonEmpty("picture", value);
    }

    public OpenidClaimSetBuilder website(String value) {
        return this.setIfNonEmpty("website", value);
    }

    public OpenidClaimSetBuilder email(String value) {
        return this.setIfNonEmpty("email", value);
    }

    public OpenidClaimSetBuilder emailVerified(Boolean value) {
        return this.setIfNonEmpty("email_verified", value);
    }

    public OpenidClaimSetBuilder gender(String value) {
        return this.setIfNonEmpty("gender", value);
    }

    public OpenidClaimSetBuilder birthdate(String value) {
        return this.setIfNonEmpty("birthdate", value);
    }

    public OpenidClaimSetBuilder zoneinfo(String value) {
        return this.setIfNonEmpty("zoneinfo", value);
    }

    public OpenidClaimSetBuilder locale(String value) {
        return this.setIfNonEmpty("locale", value);
    }

    public OpenidClaimSetBuilder phoneNumber(String value) {
        return this.setIfNonEmpty("phone_number", value);
    }

    public OpenidClaimSetBuilder phoneNumberVerified(Boolean value) {
        return this.setIfNonEmpty("phone_number_verified", value);
    }

    public OpenidClaimSetBuilder address(AddressClaim value) {
        if (value == null) {
            this.remove("address");
        } else {
            this.put("address", (Object)value);
        }
        return this;
    }

    public OpenidClaimSetBuilder claims(Map<String, Object> claims) {
        this.putAll(claims);
        return this;
    }

    public OpenidClaimSetBuilder privateClaims(Map<String, Object> claims) {
        return this.claims(claims);
    }

    public OpenidClaimSetBuilder otherClaims(Map<String, Object> claims) {
        return this.claims(claims);
    }

    public OpenidClaimSetBuilder updatedAt(Instant value) {
        return this.setIfNonEmpty("", value);
    }

    protected OpenidClaimSetBuilder setIfNonEmpty(String claimName, String claimValue) {
        if (StringUtils.hasText((String)claimValue)) {
            this.put(claimName, claimValue);
        } else {
            this.remove(claimName);
        }
        return this;
    }

    protected OpenidClaimSetBuilder setIfNonEmpty(String claimName, Collection<String> claimValue) {
        if (claimValue == null || claimValue.isEmpty()) {
            this.remove(claimName);
        } else if (claimValue.isEmpty()) {
            this.setIfNonEmpty(claimName, claimValue.iterator().next());
        } else {
            this.put(claimName, claimValue);
        }
        return this;
    }

    protected OpenidClaimSetBuilder setIfNonEmpty(String claimName, Instant claimValue) {
        if (claimValue == null) {
            this.remove(claimName);
        } else {
            this.put(claimName, claimValue.getEpochSecond());
        }
        return this;
    }

    protected OpenidClaimSetBuilder setIfNonEmpty(String claimName, Boolean claimValue) {
        if (claimValue == null) {
            this.remove(claimName);
        } else {
            this.put(claimName, claimValue);
        }
        return this;
    }

    public static final class AddressClaim
    extends ModifiableClaimSet {
        private static final long serialVersionUID = 28800769851008900L;

        public AddressClaim formatted(String value) {
            return this.setIfNonEmpty("formatted", value);
        }

        public AddressClaim streetAddress(String value) {
            return this.setIfNonEmpty("street_address", value);
        }

        public AddressClaim locality(String value) {
            return this.setIfNonEmpty("locality", value);
        }

        public AddressClaim region(String value) {
            return this.setIfNonEmpty("region", value);
        }

        public AddressClaim postalCode(String value) {
            return this.setIfNonEmpty("postal_code", value);
        }

        public AddressClaim country(String value) {
            return this.setIfNonEmpty("country", value);
        }

        private AddressClaim setIfNonEmpty(String claimName, String claimValue) {
            if (StringUtils.hasText((String)claimValue)) {
                this.put(claimName, claimValue);
            } else {
                this.remove(claimName);
            }
            return this;
        }
    }
}

