/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations;

import com.c4_soft.springaddons.security.oauth2.ModifiableClaimSet;
import com.c4_soft.springaddons.security.oauth2.test.annotations.IntClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.JsonArrayClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.JsonObjectClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.LongClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.StringArrayClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.StringClaim;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Claims {
    public IntClaim[] intClaims() default {};

    public LongClaim[] longClaims() default {};

    public StringClaim[] stringClaims() default {};

    public StringArrayClaim[] stringArrayClaims() default {};

    public JsonObjectClaim[] jsonObjectClaims() default {};

    public JsonArrayClaim[] jsonArrayClaims() default {};

    public static class Token {
        private Token() {
        }

        public static ModifiableClaimSet of(Claims annotation) {
            ModifiableClaimSet claims = new ModifiableClaimSet();
            for (IntClaim intClaim : annotation.intClaims()) {
                claims.claim(intClaim.name(), (Object)intClaim.value());
            }
            for (Annotation annotation2 : annotation.longClaims()) {
                claims.claim(annotation2.name(), (Object)annotation2.value());
            }
            for (Annotation annotation3 : annotation.stringClaims()) {
                claims.claim(annotation3.name(), annotation3.value());
            }
            for (Annotation annotation4 : annotation.stringArrayClaims()) {
                claims.claim(annotation4.name(), (Object)annotation4.value());
            }
            for (Annotation annotation5 : annotation.jsonObjectClaims()) {
                claims.claim(annotation5.name(), JsonObjectClaim.Support.parse((JsonObjectClaim)annotation5));
            }
            for (Annotation annotation6 : annotation.jsonArrayClaims()) {
                claims.claim(annotation6.name(), JsonArrayClaim.Support.parse((JsonArrayClaim)annotation6));
            }
            return claims;
        }
    }
}

