/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.oauth2.rfc7662;

import com.c4_soft.oauth2.OAuth2Authorization;
import com.c4_soft.oauth2.rfc6749.TokenType;
import com.c4_soft.oauth2.rfc7662.IntrospectionClaimSet;
import java.time.Instant;
import java.util.Collection;
import java.util.function.Consumer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class IntrospectionOAuth2Authorization
extends OAuth2Authorization<IntrospectionClaimSet, String> {
    public IntrospectionOAuth2Authorization(IntrospectionClaimSet accessToken, TokenType tokenType, @Nullable String refreshToken, @Nullable Instant expiresAt, @Nullable Collection<String> scope) {
        super(accessToken, tokenType, refreshToken, expiresAt, scope);
        if (expiresAt != null) {
            Assert.notNull((Object)accessToken.getExpiresAt(), (String)"access token expiration can't be null if authorization expires");
            Assert.isTrue((expiresAt.equals(accessToken.getExpiresAt()) || expiresAt.isAfter(accessToken.getExpiresAt()) ? 1 : 0) != 0, (String)"access token expiration must be after authorization one");
        }
    }

    public IntrospectionOAuth2Authorization(IntrospectionClaimSet accessToken, TokenType tokenType) {
        this(accessToken, tokenType, null, null, null);
    }

    public static <T extends IntrospectionClaimSet.Builder<T>> Builder<T> builder(T claimSetBuilder) {
        return new Builder<T>(claimSetBuilder);
    }

    public static <T extends IntrospectionClaimSet.Builder<T>> Builder<T> builder() {
        return IntrospectionOAuth2Authorization.builder(IntrospectionClaimSet.builder());
    }

    public static class Builder<T extends IntrospectionClaimSet.Builder<T>>
    extends OAuth2Authorization.Builder<Builder<T>, IntrospectionClaimSet, String, IntrospectionOAuth2Authorization> {
        final T claimSet;

        public Builder(T claimSetBuilder) {
            this.claimSet = claimSetBuilder;
        }

        @Override
        public Builder<T> accessToken(Consumer<T> claimsBuilderConsumer) {
            claimsBuilderConsumer.accept(this.claimSet);
            return (Builder)super.accessToken(((IntrospectionClaimSet.Builder)this.claimSet).build());
        }

        @Override
        public IntrospectionOAuth2Authorization build() {
            return new IntrospectionOAuth2Authorization((IntrospectionClaimSet)this.accessToken, this.tokenType, (String)this.refreshToken, this.expiresAt, (Collection<String>)this.scopes);
        }
    }
}

