/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.oauth2.rfc7519;

import com.c4_soft.oauth2.OAuth2Authorization;
import com.c4_soft.oauth2.rfc6749.TokenType;
import com.c4_soft.oauth2.rfc7519.JwtClaimSet;
import java.time.Instant;
import java.util.Collection;
import java.util.function.Consumer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JwtOAuth2Authorization
extends OAuth2Authorization<JwtClaimSet, String> {
    public JwtOAuth2Authorization(JwtClaimSet accessToken, TokenType tokenType, @Nullable String refreshToken, @Nullable Instant expiresAt, @Nullable Collection<String> scope) {
        super(accessToken, tokenType, refreshToken, expiresAt, scope);
        if (expiresAt != null) {
            Assert.notNull((Object)accessToken.getExpirationTime(), (String)"access token expiration can't be null if authorization expires");
            Assert.isTrue((expiresAt.equals(accessToken.getExpirationTime()) || expiresAt.isAfter(accessToken.getExpirationTime()) ? 1 : 0) != 0, (String)"access token expiration must be after authorization one");
        }
    }

    public JwtOAuth2Authorization(JwtClaimSet accessToken, TokenType tokenType) {
        this(accessToken, tokenType, null, null, null);
    }

    public static <T extends JwtClaimSet.Builder<T>> Builder<T> builder(T claimSetBuilder) {
        return new Builder<T>(claimSetBuilder);
    }

    public static <T extends JwtClaimSet.Builder<T>> Builder<T> builder() {
        return JwtOAuth2Authorization.builder(JwtClaimSet.builder());
    }

    public static class Builder<T extends JwtClaimSet.Builder<T>>
    extends OAuth2Authorization.Builder<Builder<T>, JwtClaimSet, String, JwtOAuth2Authorization> {
        final T claimSet;

        public Builder(T claimSetBuilder) {
            this.claimSet = claimSetBuilder;
        }

        @Override
        public Builder<T> accessToken(Consumer<T> claimsBuilderConsumer) {
            claimsBuilderConsumer.accept(this.claimSet);
            return (Builder)super.accessToken(((JwtClaimSet.Builder)this.claimSet).build());
        }

        @Override
        public JwtOAuth2Authorization build() {
            return new JwtOAuth2Authorization((JwtClaimSet)this.accessToken, this.tokenType, (String)this.refreshToken, this.expiresAt, (Collection<String>)this.scopes);
        }
    }
}

