/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.oauth2.rfc7519;

import com.c4_soft.oauth2.ModifiableClaimSet;
import com.c4_soft.oauth2.UnmodifiableClaimSet;
import com.c4_soft.oauth2.rfc7519.JwtRegisteredClaimNames;
import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JwtClaimSet
extends UnmodifiableClaimSet
implements Principal {
    public JwtClaimSet(Map<String, Object> claims) {
        super(claims);
    }

    @Override
    public String getName() {
        return this.getSubject();
    }

    public String getIssuer() {
        return this.getAsString(JwtRegisteredClaimNames.ISSUER.value);
    }

    public String getSubject() {
        return this.getAsString(JwtRegisteredClaimNames.SUBJECT.value);
    }

    public Collection<String> getAudience() {
        return this.getAsStringSet(JwtRegisteredClaimNames.AUDIENCE.value);
    }

    public Instant getExpirationTime() {
        return this.getAsInstant(JwtRegisteredClaimNames.EXPIRATION_TIME.value);
    }

    public Instant getNotBefore() {
        return this.getAsInstant(JwtRegisteredClaimNames.NOT_BEFORE.value);
    }

    public Instant getIssuedAt() {
        return this.getAsInstant(JwtRegisteredClaimNames.ISSUED_AT.value);
    }

    public String getJwtId() {
        return this.getAsString(JwtRegisteredClaimNames.JWT_ID.value);
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<T>>
    extends ModifiableClaimSet {
        private static final long serialVersionUID = -7716737980247084105L;

        public T issuer(String issuer) {
            this.claim(JwtRegisteredClaimNames.ISSUER.value, issuer);
            return this.downcast();
        }

        public T subject(String subject) {
            this.claim(JwtRegisteredClaimNames.SUBJECT.value, subject);
            return this.downcast();
        }

        public T audience(Stream<String> audience) {
            this.claim(JwtRegisteredClaimNames.AUDIENCE.value, audience.collect(Collectors.toSet()));
            return this.downcast();
        }

        public T audience(String ... audience) {
            return this.audience(Stream.of(audience));
        }

        public T audience(Collection<String> audience) {
            return this.audience(audience.stream());
        }

        public T expirationTime(Instant expirationTime) {
            this.claim(JwtRegisteredClaimNames.EXPIRATION_TIME.value, expirationTime.getEpochSecond());
            return this.downcast();
        }

        public T expiresIn(long seconds) {
            this.expirationTime(Instant.now().plus(Duration.ofSeconds(seconds)));
            return this.downcast();
        }

        public T notBefore(Instant notBefore) {
            this.claim(JwtRegisteredClaimNames.NOT_BEFORE.value, notBefore.getEpochSecond());
            return this.downcast();
        }

        public T issuedAt(Instant issuedAt) {
            this.claim(JwtRegisteredClaimNames.ISSUED_AT.value, issuedAt.getEpochSecond());
            return this.downcast();
        }

        public T jwtId(String jwtId) {
            this.claim(JwtRegisteredClaimNames.JWT_ID.value, jwtId);
            return this.downcast();
        }

        public JwtClaimSet build() {
            return this.build(this);
        }

        public JwtClaimSet build(Map<String, Object> claims) {
            return new JwtClaimSet(claims);
        }

        protected T downcast() {
            return (T)this;
        }
    }
}

