/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.oauth2.rfc6749.dto;

import com.c4_soft.oauth2.rfc6749.TokenType;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@Deprecated
public class SuccessfulResponseDto
implements Serializable {
    private static final long serialVersionUID = -4029156671071046624L;
    private final String accessToken;
    @Nullable
    private final String refreshToken;
    private final String tokenType;
    @Nullable
    private final Long expiresIn;
    @Nullable
    private final String scope;
    @Nullable
    private final String state;

    public SuccessfulResponseDto(String accessToken, String tokenType, @Nullable String refreshToken, @Nullable Long expiresIn, @Nullable String scope, @Nullable String state) {
        Assert.hasText((String)accessToken, (String)"accessToken must be non empty");
        Assert.hasText((String)tokenType, (String)"tokenType must be non empty");
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.tokenType = tokenType;
        this.expiresIn = expiresIn;
        this.scope = scope;
        this.state = state;
    }

    public SuccessfulResponseDto(String accessToken, String tokenType) {
        this(accessToken, tokenType, null, null, null, null);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public Long getExpiresIn() {
        return this.expiresIn;
    }

    public String getScope() {
        return this.scope;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String accessToken;
        private String refreshToken;
        private String tokenType;
        private Long expiresIn;
        private String scope;
        private String state;

        public Builder accessToken(Object accessToken) {
            this.accessToken = accessToken.toString();
            return this;
        }

        public Builder refreshToken(Object refreshToken) {
            this.refreshToken = refreshToken.toString();
            return this;
        }

        public Builder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public Builder tokenType(TokenType tokenType) {
            this.tokenType = tokenType.value;
            return this;
        }

        public Builder expiresIn(Long expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public Builder expiresAt(Instant expiresAt) {
            this.expiresIn = expiresAt == null ? null : Long.valueOf(expiresAt.getEpochSecond() - Instant.now().getEpochSecond());
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder scope(Collection<String> scope) {
            this.scope = scope.stream().collect(Collectors.joining(" "));
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public SuccessfulResponseDto build() {
            return new SuccessfulResponseDto(this.accessToken, this.tokenType, this.refreshToken, this.expiresIn, this.scope, this.state);
        }
    }
}

