/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.oauth2;

import com.c4_soft.oauth2.rfc6749.TokenType;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class OAuth2Authorization<T, U> {
    private final T accessToken;
    @Nullable
    private final U refreshToken;
    private final TokenType tokenType;
    @Nullable
    private final Instant expiresAt;
    @Nullable
    private final Set<String> scope;

    public OAuth2Authorization(T accessToken, TokenType tokenType, @Nullable U refreshToken, @Nullable Instant expiresAt, @Nullable Collection<String> scope) {
        Assert.notNull(accessToken, (String)"accessToken must be non null");
        Assert.notNull((Object)((Object)tokenType), (String)"tokenType must be non null");
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.tokenType = tokenType;
        this.expiresAt = expiresAt;
        this.scope = scope == null ? Collections.emptySet() : scope.stream().collect(Collectors.toSet());
    }

    public OAuth2Authorization(T accessToken, TokenType tokenType) {
        this(accessToken, tokenType, null, null, null);
    }

    public T getAccessToken() {
        return this.accessToken;
    }

    public U getRefreshToken() {
        return this.refreshToken;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    public Set<String> getScope() {
        return this.scope;
    }

    public static abstract class Builder<THIS_TYPE extends Builder<THIS_TYPE, ACCESS_TOKEN_TYPE, REFRESH_TOKEN_TYPE, AUTHORIZATION_TYPE>, ACCESS_TOKEN_TYPE, REFRESH_TOKEN_TYPE, AUTHORIZATION_TYPE extends OAuth2Authorization<ACCESS_TOKEN_TYPE, REFRESH_TOKEN_TYPE>> {
        protected ACCESS_TOKEN_TYPE accessToken;
        protected REFRESH_TOKEN_TYPE refreshToken;
        protected TokenType tokenType = TokenType.BEARER;
        protected Instant expiresAt;
        protected Collection<String> scopes = new HashSet<String>();

        public THIS_TYPE accessToken(ACCESS_TOKEN_TYPE accessToken) {
            this.accessToken = accessToken;
            return this.downcast();
        }

        public THIS_TYPE refreshToken(REFRESH_TOKEN_TYPE refreshToken) {
            this.refreshToken = refreshToken;
            return this.downcast();
        }

        public THIS_TYPE tokenType(TokenType tokenType) {
            this.tokenType = tokenType;
            return this.downcast();
        }

        public THIS_TYPE expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this.downcast();
        }

        public THIS_TYPE expiresIn(Long seconds) {
            this.expiresAt = Instant.now().plus(Duration.ofSeconds(seconds));
            return this.downcast();
        }

        public THIS_TYPE scope(String scope) {
            Assert.hasLength((String)scope, (String)"scope must be non empty");
            this.scopes.add(scope);
            return this.downcast();
        }

        public THIS_TYPE scopes(Stream<String> scopes) {
            this.scopes.clear();
            scopes.forEach(this::scope);
            return this.downcast();
        }

        public THIS_TYPE scopes(Collection<String> scopes) {
            return this.scopes(scopes.stream());
        }

        public THIS_TYPE scopes(String ... scopes) {
            return this.scopes(Stream.of(scopes));
        }

        public abstract AUTHORIZATION_TYPE build();

        protected THIS_TYPE downcast() {
            return (THIS_TYPE)this;
        }
    }
}

