/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.text.Spannable;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableNativeMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.IViewManagerWithChildren;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.views.text.ReactTextAnchorViewManager;
import com.facebook.react.views.text.ReactTextShadowNode;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.ReactTextView;
import com.facebook.react.views.text.TextAttributeProps;
import com.facebook.react.views.text.TextInlineImageSpan;
import com.facebook.react.views.text.TextLayoutManager;
import com.facebook.yoga.YogaMeasureMode;
import java.util.Map;

@ReactModule(name="RCTText")
public class ReactTextViewManager
extends ReactTextAnchorViewManager<ReactTextView, ReactTextShadowNode>
implements IViewManagerWithChildren {
    @VisibleForTesting
    public static final String REACT_CLASS = "RCTText";

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public ReactTextView createViewInstance(ThemedReactContext context) {
        return new ReactTextView((Context)context);
    }

    @Override
    public void updateExtraData(ReactTextView view, Object extraData) {
        ReactTextUpdate update = (ReactTextUpdate)extraData;
        if (update.containsImages()) {
            Spannable spannable = update.getText();
            TextInlineImageSpan.possiblyUpdateInlineImageSpans(spannable, (TextView)view);
        }
        view.setText(update);
    }

    @Override
    public ReactTextShadowNode createShadowNodeInstance() {
        return new ReactTextShadowNode();
    }

    @Override
    public Class<ReactTextShadowNode> getShadowNodeClass() {
        return ReactTextShadowNode.class;
    }

    @Override
    protected void onAfterUpdateTransaction(ReactTextView view) {
        super.onAfterUpdateTransaction(view);
        view.updateView();
    }

    @Override
    public boolean needsCustomLayoutForChildren() {
        return true;
    }

    @Override
    public Object updateState(ReactTextView view, ReactStylesDiffMap props, @Nullable StateWrapper stateWrapper) {
        ReadableNativeMap state = stateWrapper.getState();
        ReadableNativeMap attributedString = state.getMap("attributedString");
        ReadableNativeMap paragraphAttributes = state.getMap("paragraphAttributes");
        Spannable spanned = TextLayoutManager.getOrCreateSpannableForText(view.getContext(), attributedString);
        view.setSpanned(spanned);
        TextAttributeProps textViewProps = new TextAttributeProps(props);
        int textBreakStrategy = this.getTextBreakStrategy(paragraphAttributes.getString("textBreakStrategy"));
        int justificationMode = 0;
        return new ReactTextUpdate(spanned, state.hasKey("mostRecentEventCount") ? state.getInt("mostRecentEventCount") : -1, false, textViewProps.getTextAlign(), textBreakStrategy, justificationMode);
    }

    private int getTextBreakStrategy(@Nullable String textBreakStrategy) {
        int androidTextBreakStrategy = 1;
        if (textBreakStrategy != null) {
            switch (textBreakStrategy) {
                case "simple": {
                    androidTextBreakStrategy = 0;
                    break;
                }
                case "balanced": {
                    androidTextBreakStrategy = 2;
                    break;
                }
                default: {
                    androidTextBreakStrategy = 1;
                }
            }
        }
        return androidTextBreakStrategy;
    }

    @Override
    @Nullable
    public Map getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.of("topTextLayout", MapBuilder.of("registrationName", "onTextLayout"), "topInlineViewLayout", MapBuilder.of("registrationName", "onInlineViewLayout"));
    }

    @Override
    public long measure(Context context, ReadableMap localData, ReadableMap props, ReadableMap state, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
        return TextLayoutManager.measureText(context, localData, props, width, widthMode, height, heightMode);
    }

    @Override
    public void setPadding(ReactTextView view, int left, int top, int right, int bottom) {
        view.setPadding(left, top, right, bottom);
    }
}

