/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.checkbox;

import android.content.Context;
import android.content.res.ColorStateList;
import android.util.TypedValue;
import android.widget.CompoundButton;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.TintContextWrapper;
import androidx.core.widget.CompoundButtonCompat;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.SimpleViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.checkbox.ReactCheckBox;
import com.facebook.react.views.checkbox.ReactCheckBoxEvent;

public class ReactCheckBoxManager
extends SimpleViewManager<ReactCheckBox> {
    public static final String REACT_CLASS = "AndroidCheckBox";
    private static final CompoundButton.OnCheckedChangeListener ON_CHECKED_CHANGE_LISTENER = new CompoundButton.OnCheckedChangeListener(){

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            ReactContext reactContext = this.getReactContext(buttonView);
            reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher().dispatchEvent(new ReactCheckBoxEvent(buttonView.getId(), isChecked));
        }

        private ReactContext getReactContext(CompoundButton buttonView) {
            Context ctx = buttonView.getContext();
            ReactContext reactContext = ctx instanceof TintContextWrapper ? (ReactContext)((TintContextWrapper)ctx).getBaseContext() : (ReactContext)buttonView.getContext();
            return reactContext;
        }
    };

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    protected void addEventEmitters(ThemedReactContext reactContext, ReactCheckBox view) {
        view.setOnCheckedChangeListener(ON_CHECKED_CHANGE_LISTENER);
    }

    @Override
    protected ReactCheckBox createViewInstance(ThemedReactContext context) {
        ReactCheckBox view = new ReactCheckBox((Context)context);
        return view;
    }

    @ReactProp(name="enabled", defaultBoolean=true)
    public void setEnabled(ReactCheckBox view, boolean enabled) {
        view.setEnabled(enabled);
    }

    @ReactProp(name="on")
    public void setOn(ReactCheckBox view, boolean on) {
        view.setOnCheckedChangeListener(null);
        view.setOn(on);
        view.setOnCheckedChangeListener(ON_CHECKED_CHANGE_LISTENER);
    }

    @Override
    public void receiveCommand(@NonNull ReactCheckBox root, String commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case "setNativeValue": {
                if (args == null) break;
                this.setOn(root, args.getBoolean(0));
            }
        }
    }

    private static int getThemeColor(Context context, String colorId) {
        TypedValue value = new TypedValue();
        context.getTheme().resolveAttribute(ReactCheckBoxManager.getIdentifier(context, colorId), value, true);
        return value.data;
    }

    private static int getIdentifier(Context context, String name) {
        return context.getResources().getIdentifier(name, "attr", context.getPackageName());
    }

    @ReactProp(name="tintColors")
    public void setTintColors(ReactCheckBox view, @Nullable ReadableMap colorsMap) {
        String defaultColorIdOfCheckedState = "colorAccent";
        int trueColor = colorsMap == null || !colorsMap.hasKey("true") ? ReactCheckBoxManager.getThemeColor(view.getContext(), defaultColorIdOfCheckedState) : colorsMap.getInt("true");
        String defaultColorIdOfUncheckedState = "colorPrimaryDark";
        int falseColor = colorsMap == null || !colorsMap.hasKey("false") ? ReactCheckBoxManager.getThemeColor(view.getContext(), defaultColorIdOfUncheckedState) : colorsMap.getInt("false");
        ColorStateList csl = new ColorStateList((int[][])new int[][]{{0x10100A0}, {-16842912}}, new int[]{trueColor, falseColor});
        CompoundButtonCompat.setButtonTintList((CompoundButton)view, (ColorStateList)csl);
    }
}

