/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.SystemClock;
import android.view.View;
import androidx.annotation.AnyThread;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.facebook.common.logging.FLog;
import com.facebook.debug.holder.PrinterHolder;
import com.facebook.debug.tags.ReactDebugOverlayTags;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.NativeMap;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReactSoftException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.fabric.Binding;
import com.facebook.react.fabric.FabricComponents;
import com.facebook.react.fabric.FabricSoLoader;
import com.facebook.react.fabric.GuardedFrameCallback;
import com.facebook.react.fabric.events.EventBeatManager;
import com.facebook.react.fabric.events.EventEmitterWrapper;
import com.facebook.react.fabric.events.FabricEventEmitter;
import com.facebook.react.fabric.mounting.LayoutMetricsConversions;
import com.facebook.react.fabric.mounting.MountingManager;
import com.facebook.react.fabric.mounting.mountitems.BatchMountItem;
import com.facebook.react.fabric.mounting.mountitems.CreateMountItem;
import com.facebook.react.fabric.mounting.mountitems.DeleteMountItem;
import com.facebook.react.fabric.mounting.mountitems.DispatchCommandMountItem;
import com.facebook.react.fabric.mounting.mountitems.DispatchStringCommandMountItem;
import com.facebook.react.fabric.mounting.mountitems.InsertMountItem;
import com.facebook.react.fabric.mounting.mountitems.MountItem;
import com.facebook.react.fabric.mounting.mountitems.PreAllocateViewMountItem;
import com.facebook.react.fabric.mounting.mountitems.RemoveDeleteMultiMountItem;
import com.facebook.react.fabric.mounting.mountitems.RemoveMountItem;
import com.facebook.react.fabric.mounting.mountitems.SendAccessibilityEvent;
import com.facebook.react.fabric.mounting.mountitems.UpdateEventEmitterMountItem;
import com.facebook.react.fabric.mounting.mountitems.UpdateLayoutMountItem;
import com.facebook.react.fabric.mounting.mountitems.UpdateLocalDataMountItem;
import com.facebook.react.fabric.mounting.mountitems.UpdatePaddingMountItem;
import com.facebook.react.fabric.mounting.mountitems.UpdatePropsMountItem;
import com.facebook.react.fabric.mounting.mountitems.UpdateStateMountItem;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.uimanager.ReactRoot;
import com.facebook.react.uimanager.ReactRootViewTagGenerator;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewManagerPropertyUpdater;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.systrace.Systrace;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@SuppressLint(value={"MissingNativeLoadLibrary"})
public class FabricUIManager
implements UIManager,
LifecycleEventListener {
    public static final String TAG = "FabricUIManager";
    public static final boolean IS_DEVELOPMENT_ENVIRONMENT = false;
    public static final boolean ENABLE_FABRIC_LOGS = ReactFeatureFlags.enableFabricLogs || PrinterHolder.getPrinter().shouldDisplayLogMessage(ReactDebugOverlayTags.FABRIC_UI_MANAGER);
    private static final int FRAME_TIME_MS = 16;
    private static final int MAX_TIME_IN_FRAME_FOR_NON_BATCHED_OPERATIONS_MS = 8;
    private static final int PRE_MOUNT_ITEMS_INITIAL_SIZE_ARRAY = 250;
    @Nullable
    private Binding mBinding;
    @NonNull
    private final ReactApplicationContext mReactApplicationContext;
    @NonNull
    private final MountingManager mMountingManager;
    @NonNull
    private final EventDispatcher mEventDispatcher;
    @NonNull
    private final ConcurrentHashMap<Integer, ThemedReactContext> mReactContextForRootTag = new ConcurrentHashMap();
    @NonNull
    private final EventBeatManager mEventBeatManager;
    @NonNull
    private final Object mMountItemsLock = new Object();
    @NonNull
    private final Object mPreMountItemsLock = new Object();
    @GuardedBy(value="mMountItemsLock")
    @NonNull
    private List<MountItem> mMountItems = new ArrayList<MountItem>();
    @GuardedBy(value="mPreMountItemsLock")
    @NonNull
    private ArrayDeque<MountItem> mPreMountItems = new ArrayDeque(250);
    @ThreadConfined(value="UI")
    @NonNull
    private final DispatchUIFrameCallback mDispatchUIFrameCallback;
    @ThreadConfined(value="UI")
    private boolean mImmediatelyExecutedMountItemsOnUI = true;
    private volatile boolean mDestroyed = false;
    private long mRunStartTime = 0L;
    private long mBatchedExecutionTime = 0L;
    private long mDispatchViewUpdatesTime = 0L;
    private long mCommitStartTime = 0L;
    private long mLayoutTime = 0L;
    private long mFinishTransactionTime = 0L;
    private long mFinishTransactionCPPTime = 0L;
    private int mCurrentSynchronousCommitNumber = 10000;

    public FabricUIManager(ReactApplicationContext reactContext, ViewManagerRegistry viewManagerRegistry, EventDispatcher eventDispatcher, EventBeatManager eventBeatManager) {
        this.mDispatchUIFrameCallback = new DispatchUIFrameCallback(reactContext);
        this.mReactApplicationContext = reactContext;
        this.mMountingManager = new MountingManager(viewManagerRegistry);
        this.mEventDispatcher = eventDispatcher;
        this.mEventBeatManager = eventBeatManager;
        this.mReactApplicationContext.addLifecycleEventListener(this);
    }

    @Override
    @UiThread
    @ThreadConfined(value="UI")
    public <T extends View> int addRootView(T rootView, WritableMap initialProps, @Nullable String initialUITemplate) {
        int rootTag = ReactRootViewTagGenerator.getNextRootViewTag();
        ReactRoot reactRootView = (ReactRoot)rootView;
        ThemedReactContext reactContext = new ThemedReactContext(this.mReactApplicationContext, rootView.getContext(), reactRootView.getSurfaceID());
        this.mMountingManager.addRootView(rootTag, rootView);
        String moduleName = reactRootView.getJSModuleName();
        this.mReactContextForRootTag.put(rootTag, reactContext);
        if (ENABLE_FABRIC_LOGS) {
            FLog.d((String)TAG, (String)"Starting surface for module: %s and reactTag: %d", (Object)moduleName, (Object)rootTag);
        }
        this.mBinding.startSurface(rootTag, moduleName, (NativeMap)((Object)initialProps));
        if (initialUITemplate != null) {
            this.mBinding.renderTemplateToSurface(rootTag, initialUITemplate);
        }
        return rootTag;
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    public <T extends View> int startSurface(T rootView, String moduleName, WritableMap initialProps, int widthMeasureSpec, int heightMeasureSpec) {
        int rootTag = ReactRootViewTagGenerator.getNextRootViewTag();
        ThemedReactContext reactContext = new ThemedReactContext(this.mReactApplicationContext, rootView.getContext(), moduleName);
        if (ENABLE_FABRIC_LOGS) {
            FLog.d((String)TAG, (String)"Starting surface for module: %s and reactTag: %d", (Object)moduleName, (Object)rootTag);
        }
        this.mMountingManager.addRootView(rootTag, rootView);
        this.mReactContextForRootTag.put(rootTag, reactContext);
        this.mBinding.startSurfaceWithConstraints(rootTag, moduleName, (NativeMap)((Object)initialProps), LayoutMetricsConversions.getMinSize(widthMeasureSpec), LayoutMetricsConversions.getMaxSize(widthMeasureSpec), LayoutMetricsConversions.getMinSize(heightMeasureSpec), LayoutMetricsConversions.getMaxSize(heightMeasureSpec));
        return rootTag;
    }

    @DoNotStrip
    public void onRequestEventBeat() {
        this.mEventDispatcher.dispatchAllEvents();
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    public void stopSurface(int surfaceID) {
        this.mBinding.stopSurface(surfaceID);
    }

    @Override
    public void initialize() {
        this.mEventDispatcher.registerEventEmitter(2, new FabricEventEmitter(this));
        this.mEventDispatcher.addBatchEventDispatchedListener(this.mEventBeatManager);
    }

    @Override
    @AnyThread
    @ThreadConfined(value="ANY")
    public void onCatalystInstanceDestroy() {
        FLog.i((String)TAG, (String)"FabricUIManager.onCatalystInstanceDestroy");
        if (this.mDestroyed) {
            ReactSoftException.logSoftException(TAG, new IllegalStateException("Cannot double-destroy FabricUIManager"));
            return;
        }
        this.mDestroyed = true;
        this.mDispatchUIFrameCallback.stop();
        this.mEventDispatcher.removeBatchEventDispatchedListener(this.mEventBeatManager);
        this.mEventDispatcher.unregisterEventEmitter(2);
        this.mReactApplicationContext.removeLifecycleEventListener(this);
        this.onHostPause();
        this.mDispatchUIFrameCallback.stop();
        this.mBinding.unregister();
        this.mBinding = null;
        ViewManagerPropertyUpdater.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    @AnyThread
    @ThreadConfined(value="ANY")
    private void preallocateView(int rootTag, int reactTag, String componentName, @Nullable ReadableMap props, @Nullable Object stateWrapper, boolean isLayoutable) {
        ThemedReactContext context = this.mReactContextForRootTag.get(rootTag);
        String component = FabricComponents.getFabricComponentName(componentName);
        Object object = this.mPreMountItemsLock;
        synchronized (object) {
            this.mPreMountItems.add(new PreAllocateViewMountItem(context, rootTag, reactTag, component, props, (StateWrapper)stateWrapper, isLayoutable));
        }
    }

    @DoNotStrip
    @AnyThread
    @ThreadConfined(value="ANY")
    private MountItem createMountItem(String componentName, @Nullable ReadableMap props, @Nullable Object stateWrapper, int reactRootTag, int reactTag, boolean isLayoutable) {
        String component = FabricComponents.getFabricComponentName(componentName);
        ThemedReactContext reactContext = this.mReactContextForRootTag.get(reactRootTag);
        if (reactContext == null) {
            throw new IllegalArgumentException("Unable to find ReactContext for root: " + reactRootTag);
        }
        return new CreateMountItem(reactContext, reactRootTag, reactTag, component, props, (StateWrapper)stateWrapper, isLayoutable);
    }

    @DoNotStrip
    @AnyThread
    @ThreadConfined(value="ANY")
    private MountItem removeMountItem(int reactTag, int parentReactTag, int index) {
        return new RemoveMountItem(reactTag, parentReactTag, index);
    }

    @DoNotStrip
    @AnyThread
    @ThreadConfined(value="ANY")
    private MountItem insertMountItem(int reactTag, int parentReactTag, int index) {
        return new InsertMountItem(reactTag, parentReactTag, index);
    }

    @DoNotStrip
    @AnyThread
    @ThreadConfined(value="ANY")
    private MountItem deleteMountItem(int reactTag) {
        return new DeleteMountItem(reactTag);
    }

    @DoNotStrip
    @AnyThread
    @ThreadConfined(value="ANY")
    private MountItem removeDeleteMultiMountItem(int[] metadata) {
        return new RemoveDeleteMultiMountItem(metadata);
    }

    @DoNotStrip
    @AnyThread
    @ThreadConfined(value="ANY")
    private MountItem updateLayoutMountItem(int reactTag, int x, int y, int width, int height, int layoutDirection) {
        return new UpdateLayoutMountItem(reactTag, x, y, width, height, layoutDirection);
    }

    @DoNotStrip
    @AnyThread
    @ThreadConfined(value="ANY")
    private MountItem updatePaddingMountItem(int reactTag, int left, int top, int right, int bottom) {
        return new UpdatePaddingMountItem(reactTag, left, top, right, bottom);
    }

    @DoNotStrip
    @AnyThread
    @ThreadConfined(value="ANY")
    private MountItem updatePropsMountItem(int reactTag, ReadableMap map) {
        return new UpdatePropsMountItem(reactTag, map);
    }

    @DoNotStrip
    @AnyThread
    @ThreadConfined(value="ANY")
    private MountItem updateLocalDataMountItem(int reactTag, ReadableMap newLocalData) {
        return new UpdateLocalDataMountItem(reactTag, newLocalData);
    }

    @DoNotStrip
    @AnyThread
    @ThreadConfined(value="ANY")
    private MountItem updateStateMountItem(int reactTag, @Nullable Object stateWrapper) {
        return new UpdateStateMountItem(reactTag, (StateWrapper)stateWrapper);
    }

    @DoNotStrip
    @AnyThread
    @ThreadConfined(value="ANY")
    private MountItem updateEventEmitterMountItem(int reactTag, Object eventEmitter) {
        return new UpdateEventEmitterMountItem(reactTag, (EventEmitterWrapper)eventEmitter);
    }

    @DoNotStrip
    @AnyThread
    @ThreadConfined(value="ANY")
    private MountItem createBatchMountItem(MountItem[] items, int size, int commitNumber) {
        return new BatchMountItem(items, size, commitNumber);
    }

    @DoNotStrip
    private long measure(int rootTag, String componentName, ReadableMap localData, ReadableMap props, ReadableMap state, float minWidth, float maxWidth, float minHeight, float maxHeight) {
        return this.mMountingManager.measure((Context)this.mReactContextForRootTag.get(rootTag), componentName, localData, props, state, LayoutMetricsConversions.getYogaSize(minWidth, maxWidth), LayoutMetricsConversions.getYogaMeasureMode(minWidth, maxWidth), LayoutMetricsConversions.getYogaSize(minHeight, maxHeight), LayoutMetricsConversions.getYogaMeasureMode(minHeight, maxHeight));
    }

    @DoNotStrip
    private long measure(String componentName, @NonNull ReadableMap localData, @NonNull ReadableMap props, @NonNull ReadableMap state, float minWidth, float maxWidth, float minHeight, float maxHeight) {
        return this.mMountingManager.measure((Context)this.mReactApplicationContext, componentName, localData, props, state, LayoutMetricsConversions.getYogaSize(minWidth, maxWidth), LayoutMetricsConversions.getYogaMeasureMode(minWidth, maxWidth), LayoutMetricsConversions.getYogaSize(minHeight, maxHeight), LayoutMetricsConversions.getYogaMeasureMode(minHeight, maxHeight));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @UiThread
    @ThreadConfined(value="UI")
    public void synchronouslyUpdateViewOnUIThread(int reactTag, @NonNull ReadableMap props) {
        UiThreadUtil.assertOnUiThread();
        long time = SystemClock.uptimeMillis();
        int commitNumber = this.mCurrentSynchronousCommitNumber++;
        try {
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_UPDATE_UI_MAIN_THREAD_START, null, commitNumber);
            if (ENABLE_FABRIC_LOGS) {
                FLog.d((String)TAG, (String)"SynchronouslyUpdateViewOnUIThread for tag %d", (Object)reactTag);
            }
            this.scheduleMountItem(this.updatePropsMountItem(reactTag, props), commitNumber, time, 0L, 0L, 0L, 0L, 0L, 0L);
        }
        catch (Exception exception) {
        }
        finally {
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_UPDATE_UI_MAIN_THREAD_END, null, commitNumber);
        }
    }

    @Override
    @UiThread
    @ThreadConfined(value="UI")
    public void setAllowImmediateUIOperationExecution(boolean flag) {
        this.mImmediatelyExecutedMountItemsOnUI = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    @AnyThread
    @ThreadConfined(value="ANY")
    private void scheduleMountItem(@NonNull MountItem mountItem, int commitNumber, long commitStartTime, long diffStartTime, long diffEndTime, long layoutStartTime, long layoutEndTime, long finishTransactionStartTime, long finishTransactionEndTime) {
        boolean isBatchMountItem = mountItem instanceof BatchMountItem;
        if (isBatchMountItem) {
            this.mCommitStartTime = commitStartTime;
            this.mLayoutTime = layoutEndTime - layoutStartTime;
            this.mFinishTransactionCPPTime = finishTransactionEndTime - finishTransactionStartTime;
            this.mFinishTransactionTime = SystemClock.uptimeMillis() - finishTransactionStartTime;
            this.mDispatchViewUpdatesTime = SystemClock.uptimeMillis();
        }
        Object object = this.mMountItemsLock;
        synchronized (object) {
            this.mMountItems.add(mountItem);
        }
        if (UiThreadUtil.isOnUiThread()) {
            boolean immediateExecutionEnabled;
            boolean bl = immediateExecutionEnabled = !ReactFeatureFlags.allowDisablingImmediateExecutionOfScheduleMountItems || this.mImmediatelyExecutedMountItemsOnUI;
            if (immediateExecutionEnabled) {
                this.dispatchMountItems();
            }
        }
        if (isBatchMountItem) {
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_COMMIT_START, null, commitNumber, commitStartTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_FINISH_TRANSACTION_START, null, commitNumber, finishTransactionStartTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_FINISH_TRANSACTION_END, null, commitNumber, finishTransactionEndTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_DIFF_START, null, commitNumber, diffStartTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_DIFF_END, null, commitNumber, diffEndTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_LAYOUT_START, null, commitNumber, layoutStartTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_LAYOUT_END, null, commitNumber, layoutEndTime);
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_COMMIT_END, null, commitNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    @ThreadConfined(value="UI")
    private void dispatchMountItems() {
        List<MountItem> mountItemsToDispatch;
        this.mRunStartTime = SystemClock.uptimeMillis();
        Object object = this.mMountItemsLock;
        synchronized (object) {
            if (this.mMountItems.isEmpty()) {
                return;
            }
            mountItemsToDispatch = this.mMountItems;
            this.mMountItems = new ArrayList<MountItem>();
        }
        ArrayDeque<MountItem> mPreMountItemsToDispatch = null;
        Object object2 = this.mPreMountItemsLock;
        synchronized (object2) {
            if (!this.mPreMountItems.isEmpty()) {
                mPreMountItemsToDispatch = this.mPreMountItems;
                this.mPreMountItems = new ArrayDeque(250);
            }
        }
        if (mPreMountItemsToDispatch != null) {
            Systrace.beginSection(0L, "FabricUIManager::mountViews preMountItems to execute: " + mPreMountItemsToDispatch.size());
            while (!mPreMountItemsToDispatch.isEmpty()) {
                mPreMountItemsToDispatch.pollFirst().execute(this.mMountingManager);
            }
            Systrace.endSection(0L);
        }
        Systrace.beginSection(0L, "FabricUIManager::mountViews mountItems to execute: " + mountItemsToDispatch.size());
        long batchedExecutionStartTime = SystemClock.uptimeMillis();
        for (MountItem mountItem : mountItemsToDispatch) {
            if (ENABLE_FABRIC_LOGS) {
                String[] mountItemLines;
                for (String m : mountItemLines = mountItem.toString().split("\n")) {
                    FLog.d((String)TAG, (String)("dispatchMountItems: Executing mountItem: " + m));
                }
            }
            mountItem.execute(this.mMountingManager);
        }
        this.mBatchedExecutionTime = SystemClock.uptimeMillis() - batchedExecutionStartTime;
        Systrace.endSection(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    @ThreadConfined(value="UI")
    private void dispatchPreMountItems(long frameTimeNanos) {
        long timeLeftInFrame;
        Systrace.beginSection(0L, "FabricUIManager::premountViews");
        while ((timeLeftInFrame = 16L - (System.nanoTime() - frameTimeNanos) / 1000000L) >= 8L) {
            MountItem preMountItemsToDispatch;
            Object object = this.mPreMountItemsLock;
            synchronized (object) {
                if (this.mPreMountItems.isEmpty()) {
                    break;
                }
                preMountItemsToDispatch = this.mPreMountItems.pollFirst();
            }
            preMountItemsToDispatch.execute(this.mMountingManager);
        }
        Systrace.endSection(0L);
    }

    public void setBinding(Binding binding) {
        this.mBinding = binding;
    }

    @Override
    @UiThread
    @ThreadConfined(value="UI")
    public void updateRootLayoutSpecs(int rootTag, int widthMeasureSpec, int heightMeasureSpec) {
        if (ENABLE_FABRIC_LOGS) {
            FLog.d((String)TAG, (String)"Updating Root Layout Specs");
        }
        this.mBinding.setConstraints(rootTag, LayoutMetricsConversions.getMinSize(widthMeasureSpec), LayoutMetricsConversions.getMaxSize(widthMeasureSpec), LayoutMetricsConversions.getMinSize(heightMeasureSpec), LayoutMetricsConversions.getMaxSize(heightMeasureSpec));
    }

    public void receiveEvent(int reactTag, String eventName, @Nullable WritableMap params) {
        EventEmitterWrapper eventEmitter = this.mMountingManager.getEventEmitter(reactTag);
        if (eventEmitter == null) {
            FLog.d((String)TAG, (String)("Unable to invoke event: " + eventName + " for reactTag: " + reactTag));
            return;
        }
        eventEmitter.invoke(eventName, params);
    }

    @Override
    public void onHostResume() {
        ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, this.mDispatchUIFrameCallback);
    }

    @Override
    public void onHostPause() {
        ReactChoreographer.getInstance().removeFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, this.mDispatchUIFrameCallback);
    }

    @Override
    public void onHostDestroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    @AnyThread
    @ThreadConfined(value="ANY")
    public void dispatchCommand(int reactTag, int commandId, @Nullable ReadableArray commandArgs) {
        Object object = this.mMountItemsLock;
        synchronized (object) {
            this.mMountItems.add(new DispatchCommandMountItem(reactTag, commandId, commandArgs));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AnyThread
    @ThreadConfined(value="ANY")
    public void dispatchCommand(int reactTag, String commandId, @Nullable ReadableArray commandArgs) {
        Object object = this.mMountItemsLock;
        synchronized (object) {
            this.mMountItems.add(new DispatchStringCommandMountItem(reactTag, commandId, commandArgs));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AnyThread
    @ThreadConfined(value="ANY")
    public void sendAccessibilityEvent(int reactTag, int eventType) {
        Object object = this.mMountItemsLock;
        synchronized (object) {
            this.mMountItems.add(new SendAccessibilityEvent(reactTag, eventType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    public void setJSResponder(final int reactTag, final int initialReactTag, final boolean blockNativeResponder) {
        Object object = this.mMountItemsLock;
        synchronized (object) {
            this.mMountItems.add(new MountItem(){

                @Override
                public void execute(MountingManager mountingManager) {
                    mountingManager.setJSResponder(reactTag, initialReactTag, blockNativeResponder);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    public void clearJSResponder() {
        Object object = this.mMountItemsLock;
        synchronized (object) {
            this.mMountItems.add(new MountItem(){

                @Override
                public void execute(MountingManager mountingManager) {
                    mountingManager.clearJSResponder();
                }
            });
        }
    }

    @Override
    public void profileNextBatch() {
    }

    @Override
    public Map<String, Long> getPerformanceCounters() {
        HashMap<String, Long> performanceCounters = new HashMap<String, Long>();
        performanceCounters.put("CommitStartTime", this.mCommitStartTime);
        performanceCounters.put("LayoutTime", this.mLayoutTime);
        performanceCounters.put("DispatchViewUpdatesTime", this.mDispatchViewUpdatesTime);
        performanceCounters.put("RunStartTime", this.mRunStartTime);
        performanceCounters.put("BatchedExecutionTime", this.mBatchedExecutionTime);
        performanceCounters.put("FinishFabricTransactionTime", this.mFinishTransactionTime);
        performanceCounters.put("FinishFabricTransactionCPPTime", this.mFinishTransactionCPPTime);
        return performanceCounters;
    }

    static {
        FabricSoLoader.staticInit();
    }

    private class DispatchUIFrameCallback
    extends GuardedFrameCallback {
        private volatile boolean mIsMountingEnabled;

        private DispatchUIFrameCallback(ReactContext reactContext) {
            super(reactContext);
            this.mIsMountingEnabled = true;
        }

        @AnyThread
        void stop() {
            this.mIsMountingEnabled = false;
        }

        @Override
        @UiThread
        @ThreadConfined(value="UI")
        public void doFrameGuarded(long frameTimeNanos) {
            if (!this.mIsMountingEnabled || FabricUIManager.this.mDestroyed) {
                FLog.w((String)"ReactNative", (String)"Not flushing pending UI operations because of previously thrown Exception");
                return;
            }
            try {
                FabricUIManager.this.dispatchPreMountItems(frameTimeNanos);
                FabricUIManager.this.dispatchMountItems();
            }
            catch (Exception ex) {
                FLog.i((String)"ReactNative", (String)"Exception thrown when executing UIFrameGuarded", (Throwable)ex);
                this.stop();
                throw ex;
            }
            finally {
                ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.DISPATCH_UI, FabricUIManager.this.mDispatchUIFrameCallback);
            }
        }
    }
}

