/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.common;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import java.util.concurrent.TimeUnit;

public class ShakeDetector
implements SensorEventListener {
    private static final long MIN_TIME_BETWEEN_SAMPLES_NS = TimeUnit.NANOSECONDS.convert(20L, TimeUnit.MILLISECONDS);
    private static final float SHAKING_WINDOW_NS = TimeUnit.NANOSECONDS.convert(3L, TimeUnit.SECONDS);
    private static final float REQUIRED_FORCE = 13.042845f;
    private float mAccelerationX;
    private float mAccelerationY;
    private float mAccelerationZ;
    private final ShakeListener mShakeListener;
    @Nullable
    private SensorManager mSensorManager;
    private long mLastTimestamp;
    private int mNumShakes;
    private long mLastShakeTimestamp;
    private int mMinNumShakes;

    public ShakeDetector(ShakeListener listener) {
        this(listener, 1);
    }

    public ShakeDetector(ShakeListener listener, int minNumShakes) {
        this.mShakeListener = listener;
        this.mMinNumShakes = minNumShakes;
    }

    public void start(SensorManager manager) {
        Assertions.assertNotNull((Object)manager);
        Sensor accelerometer = manager.getDefaultSensor(1);
        if (accelerometer != null) {
            this.mSensorManager = manager;
            this.mLastTimestamp = -1L;
            this.mSensorManager.registerListener((SensorEventListener)this, accelerometer, 2);
            this.mLastShakeTimestamp = 0L;
            this.reset();
        }
    }

    public void stop() {
        if (this.mSensorManager != null) {
            this.mSensorManager.unregisterListener((SensorEventListener)this);
            this.mSensorManager = null;
        }
    }

    private void reset() {
        this.mNumShakes = 0;
        this.mAccelerationX = 0.0f;
        this.mAccelerationY = 0.0f;
        this.mAccelerationZ = 0.0f;
    }

    private boolean atLeastRequiredForce(float a) {
        return Math.abs(a) > 13.042845f;
    }

    private void recordShake(long timestamp) {
        this.mLastShakeTimestamp = timestamp;
        ++this.mNumShakes;
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        if (sensorEvent.timestamp - this.mLastTimestamp < MIN_TIME_BETWEEN_SAMPLES_NS) {
            return;
        }
        float ax = sensorEvent.values[0];
        float ay = sensorEvent.values[1];
        float az = sensorEvent.values[2] - 9.80665f;
        this.mLastTimestamp = sensorEvent.timestamp;
        if (this.atLeastRequiredForce(ax) && ax * this.mAccelerationX <= 0.0f) {
            this.recordShake(sensorEvent.timestamp);
            this.mAccelerationX = ax;
        } else if (this.atLeastRequiredForce(ay) && ay * this.mAccelerationY <= 0.0f) {
            this.recordShake(sensorEvent.timestamp);
            this.mAccelerationY = ay;
        } else if (this.atLeastRequiredForce(az) && az * this.mAccelerationZ <= 0.0f) {
            this.recordShake(sensorEvent.timestamp);
            this.mAccelerationZ = az;
        }
        this.maybeDispatchShake(sensorEvent.timestamp);
    }

    public void onAccuracyChanged(Sensor sensor, int i) {
    }

    private void maybeDispatchShake(long currentTimestamp) {
        if (this.mNumShakes >= 8 * this.mMinNumShakes) {
            this.reset();
            this.mShakeListener.onShake();
        }
        if ((float)(currentTimestamp - this.mLastShakeTimestamp) > SHAKING_WINDOW_NS) {
            this.reset();
        }
    }

    public static interface ShakeListener {
        public void onShake();
    }
}

