/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.image;

import android.graphics.Shader;
import androidx.annotation.Nullable;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.views.image.ScaleTypeStartInside;

public class ImageResizeMode {
    public static ScalingUtils.ScaleType toScaleType(@Nullable String resizeModeValue) {
        if ("contain".equals(resizeModeValue)) {
            return ScalingUtils.ScaleType.FIT_CENTER;
        }
        if ("cover".equals(resizeModeValue)) {
            return ScalingUtils.ScaleType.CENTER_CROP;
        }
        if ("stretch".equals(resizeModeValue)) {
            return ScalingUtils.ScaleType.FIT_XY;
        }
        if ("center".equals(resizeModeValue)) {
            return ScalingUtils.ScaleType.CENTER_INSIDE;
        }
        if ("repeat".equals(resizeModeValue)) {
            return ScaleTypeStartInside.INSTANCE;
        }
        if (resizeModeValue == null) {
            return ImageResizeMode.defaultValue();
        }
        throw new JSApplicationIllegalArgumentException("Invalid resize mode: '" + resizeModeValue + "'");
    }

    public static Shader.TileMode toTileMode(@Nullable String resizeModeValue) {
        if ("contain".equals(resizeModeValue) || "cover".equals(resizeModeValue) || "stretch".equals(resizeModeValue) || "center".equals(resizeModeValue)) {
            return Shader.TileMode.CLAMP;
        }
        if ("repeat".equals(resizeModeValue)) {
            return Shader.TileMode.REPEAT;
        }
        if (resizeModeValue == null) {
            return ImageResizeMode.defaultTileMode();
        }
        throw new JSApplicationIllegalArgumentException("Invalid resize mode: '" + resizeModeValue + "'");
    }

    public static ScalingUtils.ScaleType defaultValue() {
        return ScalingUtils.ScaleType.CENTER_CROP;
    }

    public static Shader.TileMode defaultTileMode() {
        return Shader.TileMode.CLAMP;
    }
}

