/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.SpannableString;
import android.text.style.URLSpan;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import androidx.annotation.Nullable;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.facebook.react.R;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import java.util.HashMap;

public class ReactAccessibilityDelegate
extends AccessibilityDelegateCompat {
    private static final String TAG = "ReactAccessibilityDelegate";
    private static int sCounter = 0x3F000000;
    private static final int TIMEOUT_SEND_ACCESSIBILITY_EVENT = 200;
    private static final int SEND_EVENT = 1;
    public static final HashMap<String, Integer> sActionIdMap = new HashMap();
    private Handler mHandler;
    private final HashMap<Integer, String> mAccessibilityActionsMap = new HashMap();
    private static final String STATE_DISABLED = "disabled";
    private static final String STATE_SELECTED = "selected";
    private static final String STATE_CHECKED = "checked";

    private void scheduleAccessibilityEventSender(View host) {
        if (this.mHandler.hasMessages(1, (Object)host)) {
            this.mHandler.removeMessages(1, (Object)host);
        }
        Message msg = this.mHandler.obtainMessage(1, (Object)host);
        this.mHandler.sendMessageDelayed(msg, 200L);
    }

    public ReactAccessibilityDelegate() {
        this.mHandler = new Handler(){

            public void handleMessage(Message msg) {
                View host = (View)msg.obj;
                host.sendAccessibilityEvent(4);
            }
        };
    }

    public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
        ReadableMap accessibilityValue;
        ReadableArray accessibilityActions;
        ReadableMap accessibilityState;
        super.onInitializeAccessibilityNodeInfo(host, info);
        AccessibilityRole accessibilityRole = (AccessibilityRole)((Object)host.getTag(R.id.accessibility_role));
        if (accessibilityRole != null) {
            ReactAccessibilityDelegate.setRole(info, accessibilityRole, host.getContext());
        }
        if ((accessibilityState = (ReadableMap)host.getTag(R.id.accessibility_state)) != null) {
            ReactAccessibilityDelegate.setState(info, accessibilityState, host.getContext());
        }
        if ((accessibilityActions = (ReadableArray)host.getTag(R.id.accessibility_actions)) != null) {
            for (int i = 0; i < accessibilityActions.size(); ++i) {
                String actionLabel;
                ReadableMap action = accessibilityActions.getMap(i);
                if (!action.hasKey("name")) {
                    throw new IllegalArgumentException("Unknown accessibility action.");
                }
                int actionId = sCounter;
                String string2 = actionLabel = action.hasKey("label") ? action.getString("label") : null;
                if (sActionIdMap.containsKey(action.getString("name"))) {
                    actionId = sActionIdMap.get(action.getString("name"));
                } else {
                    ++sCounter;
                }
                this.mAccessibilityActionsMap.put(actionId, action.getString("name"));
                AccessibilityNodeInfoCompat.AccessibilityActionCompat accessibilityAction = new AccessibilityNodeInfoCompat.AccessibilityActionCompat(actionId, (CharSequence)actionLabel);
                info.addAction(accessibilityAction);
            }
        }
        if ((accessibilityValue = (ReadableMap)host.getTag(R.id.accessibility_value)) != null && accessibilityValue.hasKey("min") && accessibilityValue.hasKey("now") && accessibilityValue.hasKey("max")) {
            Dynamic minDynamic = accessibilityValue.getDynamic("min");
            Dynamic nowDynamic = accessibilityValue.getDynamic("now");
            Dynamic maxDynamic = accessibilityValue.getDynamic("max");
            if (minDynamic != null && minDynamic.getType() == ReadableType.Number && nowDynamic != null && nowDynamic.getType() == ReadableType.Number && maxDynamic != null && maxDynamic.getType() == ReadableType.Number) {
                int min = minDynamic.asInt();
                int now = nowDynamic.asInt();
                int max = maxDynamic.asInt();
                if (max > min && now >= min && max >= now) {
                    info.setRangeInfo(AccessibilityNodeInfoCompat.RangeInfoCompat.obtain((int)0, (float)min, (float)max, (float)now));
                }
            }
        }
    }

    public void onInitializeAccessibilityEvent(View host, AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(host, event);
        ReadableMap accessibilityValue = (ReadableMap)host.getTag(R.id.accessibility_value);
        if (accessibilityValue != null && accessibilityValue.hasKey("min") && accessibilityValue.hasKey("now") && accessibilityValue.hasKey("max")) {
            Dynamic minDynamic = accessibilityValue.getDynamic("min");
            Dynamic nowDynamic = accessibilityValue.getDynamic("now");
            Dynamic maxDynamic = accessibilityValue.getDynamic("max");
            if (minDynamic != null && minDynamic.getType() == ReadableType.Number && nowDynamic != null && nowDynamic.getType() == ReadableType.Number && maxDynamic != null && maxDynamic.getType() == ReadableType.Number) {
                int min = minDynamic.asInt();
                int now = nowDynamic.asInt();
                int max = maxDynamic.asInt();
                if (max > min && now >= min && max >= now) {
                    event.setItemCount(max - min);
                    event.setCurrentItemIndex(now);
                }
            }
        }
    }

    public boolean performAccessibilityAction(View host, int action, Bundle args) {
        if (this.mAccessibilityActionsMap.containsKey(action)) {
            WritableMap event = Arguments.createMap();
            event.putString("actionName", this.mAccessibilityActionsMap.get(action));
            ReactContext reactContext = (ReactContext)host.getContext();
            if (reactContext.hasActiveCatalystInstance()) {
                reactContext.getJSModule(RCTEventEmitter.class).receiveEvent(host.getId(), "topAccessibilityAction", event);
            } else {
                ReactSoftException.logSoftException(TAG, new ReactNoCrashSoftException("Cannot get RCTEventEmitter, no CatalystInstance"));
            }
            AccessibilityRole accessibilityRole = (AccessibilityRole)((Object)host.getTag(R.id.accessibility_role));
            ReadableMap accessibilityValue = (ReadableMap)host.getTag(R.id.accessibility_value);
            if (accessibilityRole == AccessibilityRole.ADJUSTABLE && (action == AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_FORWARD.getId() || action == AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_BACKWARD.getId())) {
                if (accessibilityValue != null && !accessibilityValue.hasKey("text")) {
                    this.scheduleAccessibilityEventSender(host);
                }
                return super.performAccessibilityAction(host, action, args);
            }
            return true;
        }
        return super.performAccessibilityAction(host, action, args);
    }

    private static void setState(AccessibilityNodeInfoCompat info, ReadableMap accessibilityState, Context context) {
        ReadableMapKeySetIterator i = accessibilityState.keySetIterator();
        while (i.hasNextKey()) {
            String state = i.nextKey();
            Dynamic value = accessibilityState.getDynamic(state);
            if (state.equals(STATE_SELECTED) && value.getType() == ReadableType.Boolean) {
                info.setSelected(value.asBoolean());
                continue;
            }
            if (state.equals(STATE_DISABLED) && value.getType() == ReadableType.Boolean) {
                info.setEnabled(!value.asBoolean());
                continue;
            }
            if (!state.equals(STATE_CHECKED) || value.getType() != ReadableType.Boolean) continue;
            boolean boolValue = value.asBoolean();
            info.setCheckable(true);
            info.setChecked(boolValue);
            if (!info.getClassName().equals(AccessibilityRole.getValue(AccessibilityRole.SWITCH))) continue;
            info.setText((CharSequence)context.getString(boolValue ? R.string.state_on_description : R.string.state_off_description));
        }
    }

    public static void setRole(AccessibilityNodeInfoCompat nodeInfo, AccessibilityRole role, Context context) {
        if (role == null) {
            role = AccessibilityRole.NONE;
        }
        nodeInfo.setClassName((CharSequence)AccessibilityRole.getValue(role));
        if (role.equals((Object)AccessibilityRole.LINK)) {
            SpannableString spannable;
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.link_description));
            if (nodeInfo.getContentDescription() != null) {
                spannable = new SpannableString(nodeInfo.getContentDescription());
                spannable.setSpan((Object)new URLSpan(""), 0, spannable.length(), 0);
                nodeInfo.setContentDescription((CharSequence)spannable);
            }
            if (nodeInfo.getText() != null) {
                spannable = new SpannableString(nodeInfo.getText());
                spannable.setSpan((Object)new URLSpan(""), 0, spannable.length(), 0);
                nodeInfo.setText((CharSequence)spannable);
            }
        } else if (role.equals((Object)AccessibilityRole.SEARCH)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.search_description));
        } else if (role.equals((Object)AccessibilityRole.IMAGE)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.image_description));
        } else if (role.equals((Object)AccessibilityRole.IMAGEBUTTON)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.imagebutton_description));
            nodeInfo.setClickable(true);
        } else if (role.equals((Object)AccessibilityRole.BUTTON)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.button_description));
            nodeInfo.setClickable(true);
        } else if (role.equals((Object)AccessibilityRole.SUMMARY)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.summary_description));
        } else if (role.equals((Object)AccessibilityRole.HEADER)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.header_description));
            AccessibilityNodeInfoCompat.CollectionItemInfoCompat itemInfo = AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)0, (int)1, (int)0, (int)1, (boolean)true);
            nodeInfo.setCollectionItemInfo((Object)itemInfo);
        } else if (role.equals((Object)AccessibilityRole.ALERT)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.alert_description));
        } else if (role.equals((Object)AccessibilityRole.COMBOBOX)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.combobox_description));
        } else if (role.equals((Object)AccessibilityRole.MENU)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.menu_description));
        } else if (role.equals((Object)AccessibilityRole.MENUBAR)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.menubar_description));
        } else if (role.equals((Object)AccessibilityRole.MENUITEM)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.menuitem_description));
        } else if (role.equals((Object)AccessibilityRole.PROGRESSBAR)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.progressbar_description));
        } else if (role.equals((Object)AccessibilityRole.RADIOGROUP)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.radiogroup_description));
        } else if (role.equals((Object)AccessibilityRole.SCROLLBAR)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.scrollbar_description));
        } else if (role.equals((Object)AccessibilityRole.SPINBUTTON)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.spinbutton_description));
        } else if (role.equals((Object)AccessibilityRole.TAB)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.rn_tab_description));
        } else if (role.equals((Object)AccessibilityRole.TABLIST)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.tablist_description));
        } else if (role.equals((Object)AccessibilityRole.TIMER)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.timer_description));
        } else if (role.equals((Object)AccessibilityRole.TOOLBAR)) {
            nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.toolbar_description));
        }
    }

    public static void setDelegate(View view) {
        if (!(ViewCompat.hasAccessibilityDelegate((View)view) || view.getTag(R.id.accessibility_role) == null && view.getTag(R.id.accessibility_state) == null && view.getTag(R.id.accessibility_actions) == null)) {
            ViewCompat.setAccessibilityDelegate((View)view, (AccessibilityDelegateCompat)new ReactAccessibilityDelegate());
        }
    }

    static {
        sActionIdMap.put("activate", AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_CLICK.getId());
        sActionIdMap.put("longpress", AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_LONG_CLICK.getId());
        sActionIdMap.put("increment", AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_FORWARD.getId());
        sActionIdMap.put("decrement", AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_BACKWARD.getId());
    }

    public static enum AccessibilityRole {
        NONE,
        BUTTON,
        LINK,
        SEARCH,
        IMAGE,
        IMAGEBUTTON,
        KEYBOARDKEY,
        TEXT,
        ADJUSTABLE,
        SUMMARY,
        HEADER,
        ALERT,
        CHECKBOX,
        COMBOBOX,
        MENU,
        MENUBAR,
        MENUITEM,
        PROGRESSBAR,
        RADIO,
        RADIOGROUP,
        SCROLLBAR,
        SPINBUTTON,
        SWITCH,
        TAB,
        TABLIST,
        TIMER,
        TOOLBAR;


        public static String getValue(AccessibilityRole role) {
            switch (role) {
                case BUTTON: {
                    return "android.widget.Button";
                }
                case SEARCH: {
                    return "android.widget.EditText";
                }
                case IMAGE: {
                    return "android.widget.ImageView";
                }
                case IMAGEBUTTON: {
                    return "android.widget.ImageButon";
                }
                case KEYBOARDKEY: {
                    return "android.inputmethodservice.Keyboard$Key";
                }
                case TEXT: {
                    return "android.widget.TextView";
                }
                case ADJUSTABLE: {
                    return "android.widget.SeekBar";
                }
                case CHECKBOX: {
                    return "android.widget.CheckBox";
                }
                case RADIO: {
                    return "android.widget.RadioButton";
                }
                case SPINBUTTON: {
                    return "android.widget.SpinButton";
                }
                case SWITCH: {
                    return "android.widget.Switch";
                }
                case NONE: 
                case LINK: 
                case SUMMARY: 
                case HEADER: 
                case ALERT: 
                case COMBOBOX: 
                case MENU: 
                case MENUBAR: 
                case MENUITEM: 
                case PROGRESSBAR: 
                case RADIOGROUP: 
                case SCROLLBAR: 
                case TAB: 
                case TABLIST: 
                case TIMER: 
                case TOOLBAR: {
                    return "android.view.View";
                }
            }
            throw new IllegalArgumentException("Invalid accessibility role value: " + (Object)((Object)role));
        }

        public static AccessibilityRole fromValue(@Nullable String value) {
            for (AccessibilityRole role : AccessibilityRole.values()) {
                if (!role.name().equalsIgnoreCase(value)) continue;
                return role;
            }
            throw new IllegalArgumentException("Invalid accessibility role value: " + value);
        }
    }
}

