/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting.mountitems;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.fabric.FabricUIManager;
import com.facebook.react.fabric.mounting.MountingManager;
import com.facebook.react.fabric.mounting.mountitems.MountItem;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;

public class PreAllocateViewMountItem
implements MountItem {
    @NonNull
    private final String mComponent;
    private final int mRootTag;
    private final int mReactTag;
    @Nullable
    private final ReadableMap mProps;
    @Nullable
    private final StateWrapper mStateWrapper;
    @NonNull
    private final ThemedReactContext mContext;
    private final boolean mIsLayoutable;

    public PreAllocateViewMountItem(@NonNull ThemedReactContext context, int rootTag, int reactTag, @NonNull String component, @Nullable ReadableMap props, @NonNull StateWrapper stateWrapper, boolean isLayoutable) {
        this.mContext = context;
        this.mComponent = component;
        this.mRootTag = rootTag;
        this.mProps = props;
        this.mStateWrapper = stateWrapper;
        this.mReactTag = reactTag;
        this.mIsLayoutable = isLayoutable;
    }

    @Override
    public void execute(@NonNull MountingManager mountingManager) {
        if (FabricUIManager.ENABLE_FABRIC_LOGS) {
            FLog.d((String)"FabricUIManager", (String)("Executing pre-allocation of: " + this.toString()));
        }
        mountingManager.preallocateView(this.mContext, this.mComponent, this.mReactTag, this.mProps, this.mStateWrapper, this.mIsLayoutable);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("PreAllocateViewMountItem [").append(this.mReactTag).append("] - component: ").append(this.mComponent).append(" rootTag: ").append(this.mRootTag).append(" isLayoutable: ").append(this.mIsLayoutable);
        return result.toString();
    }
}

