/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.network;

import androidx.annotation.Nullable;
import com.facebook.react.modules.network.ProgressListener;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public class ProgressResponseBody
extends ResponseBody {
    private final ResponseBody mResponseBody;
    private final ProgressListener mProgressListener;
    @Nullable
    private BufferedSource mBufferedSource;
    private long mTotalBytesRead;

    public ProgressResponseBody(ResponseBody responseBody, ProgressListener progressListener) {
        this.mResponseBody = responseBody;
        this.mProgressListener = progressListener;
        this.mTotalBytesRead = 0L;
    }

    public MediaType contentType() {
        return this.mResponseBody.contentType();
    }

    public long contentLength() {
        return this.mResponseBody.contentLength();
    }

    public long totalBytesRead() {
        return this.mTotalBytesRead;
    }

    public BufferedSource source() {
        if (this.mBufferedSource == null) {
            this.mBufferedSource = Okio.buffer((Source)this.source((Source)this.mResponseBody.source()));
        }
        return this.mBufferedSource;
    }

    private Source source(Source source) {
        return new ForwardingSource(source){

            public long read(Buffer sink, long byteCount) throws IOException {
                long bytesRead = super.read(sink, byteCount);
                ProgressResponseBody.this.mTotalBytesRead = ProgressResponseBody.this.mTotalBytesRead + (bytesRead != -1L ? bytesRead : 0L);
                ProgressResponseBody.this.mProgressListener.onProgress(ProgressResponseBody.this.mTotalBytesRead, ProgressResponseBody.this.mResponseBody.contentLength(), bytesRead == -1L);
                return bytesRead;
            }
        };
    }
}

