/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.debug;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.devsupport.interfaces.DevOptionHandler;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.DeviceEventManagerModule;

@ReactModule(name="DevSettings")
public class DevSettingsModule
extends ReactContextBaseJavaModule {
    public static final String NAME = "DevSettings";
    private final DevSupportManager mDevSupportManager;

    public DevSettingsModule(ReactApplicationContext reactContext, DevSupportManager devSupportManager) {
        super(reactContext);
        this.mDevSupportManager = devSupportManager;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @ReactMethod
    public void reload() {
        if (this.mDevSupportManager.getDevSupportEnabled()) {
            UiThreadUtil.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    DevSettingsModule.this.mDevSupportManager.handleReloadJS();
                }
            });
        }
    }

    @ReactMethod
    public void reloadWithReason(String reason) {
        this.reload();
    }

    @ReactMethod
    public void onFastRefresh() {
    }

    @ReactMethod
    public void setHotLoadingEnabled(boolean isHotLoadingEnabled) {
        this.mDevSupportManager.setHotModuleReplacementEnabled(isHotLoadingEnabled);
    }

    @ReactMethod
    public void setIsDebuggingRemotely(boolean isDebugginRemotelyEnabled) {
        this.mDevSupportManager.setRemoteJSDebugEnabled(isDebugginRemotelyEnabled);
    }

    @ReactMethod
    public void setProfilingEnabled(boolean isProfilingEnabled) {
        this.mDevSupportManager.setFpsDebugEnabled(isProfilingEnabled);
    }

    @ReactMethod
    public void toggleElementInspector() {
        this.mDevSupportManager.toggleElementInspector();
    }

    @ReactMethod
    public void addMenuItem(final String title) {
        this.mDevSupportManager.addCustomDevOption(title, new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                WritableMap data = Arguments.createMap();
                data.putString("title", title);
                ReactApplicationContext reactApplicationContext = DevSettingsModule.this.getReactApplicationContextIfActiveOrWarn();
                if (reactApplicationContext != null) {
                    reactApplicationContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit("didPressMenuItem", data);
                }
            }
        });
    }
}

