/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.jni;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.atomic.AtomicReference;

public class DestructorThread {
    private static DestructorList sDestructorList;
    private static DestructorStack sDestructorStack;
    private static ReferenceQueue sReferenceQueue;
    private static Thread sThread;

    static {
        sDestructorStack = new DestructorStack();
        sReferenceQueue = new ReferenceQueue();
        sDestructorList = new DestructorList();
        sThread = new Thread("HybridData DestructorThread"){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Destructor current = (Destructor)sReferenceQueue.remove();
                            current.destruct();
                            if (current.previous == null) {
                                sDestructorStack.transferAllToList();
                            }
                            DestructorList.drop(current);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        };
        sThread.start();
    }

    private static class DestructorList {
        private Destructor mHead = new Terminus();

        public DestructorList() {
            this.mHead.next = (Destructor)new Terminus();
            this.mHead.next.previous = this.mHead;
        }

        public void enqueue(Destructor current) {
            current.next = this.mHead.next;
            this.mHead.next = current;
            current.next.previous = current;
            current.previous = this.mHead;
        }

        private static void drop(Destructor current) {
            current.next.previous = current.previous;
            current.previous.next = current.next;
        }
    }

    private static class DestructorStack {
        private AtomicReference<Destructor> mHead = new AtomicReference();

        private DestructorStack() {
        }

        public void push(Destructor newHead) {
            Destructor oldHead;
            do {
                oldHead = this.mHead.get();
                newHead.next = oldHead;
            } while (!this.mHead.compareAndSet(oldHead, newHead));
        }

        public void transferAllToList() {
            Destructor current = this.mHead.getAndSet(null);
            while (current != null) {
                Destructor next = current.next;
                sDestructorList.enqueue(current);
                current = next;
            }
        }
    }

    private static class Terminus
    extends Destructor {
        private Terminus() {
        }

        @Override
        void destruct() {
            throw new IllegalStateException("Cannot destroy Terminus Destructor.");
        }
    }

    public static abstract class Destructor
    extends PhantomReference<Object> {
        private Destructor next;
        private Destructor previous;

        Destructor(Object referent) {
            super(referent, sReferenceQueue);
            sDestructorStack.push(this);
        }

        private Destructor() {
            super(null, sReferenceQueue);
        }

        abstract void destruct();
    }
}

