/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.os.SystemClock;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.soloader.SoLoader;
import com.facebook.systrace.Systrace;

public class ReactBridge {
    private static volatile long sLoadStartTime = 0L;
    private static volatile long sLoadEndTime = 0L;
    private static boolean sDidInit = false;

    public static synchronized void staticInit() {
        if (sDidInit) {
            return;
        }
        sDidInit = true;
        sLoadStartTime = SystemClock.uptimeMillis();
        Systrace.beginSection(0L, "ReactBridge.staticInit::load:reactnativejni");
        ReactMarker.logMarker(ReactMarkerConstants.LOAD_REACT_NATIVE_SO_FILE_START);
        SoLoader.loadLibrary((String)"reactnativejni");
        ReactMarker.logMarker(ReactMarkerConstants.LOAD_REACT_NATIVE_SO_FILE_END);
        Systrace.endSection(0L);
        sLoadEndTime = SystemClock.uptimeMillis();
    }

    public static long getLoadStartTime() {
        return sLoadStartTime;
    }

    public static long getLoadEndTime() {
        return sLoadEndTime;
    }
}

