/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v7.widget.AppCompatTextView;
import android.text.Layout;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.common.logging.FLog;
import com.facebook.react.uimanager.ReactCompoundView;
import com.facebook.react.views.text.ReactTagSpan;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.TextInlineImageSpan;
import com.facebook.react.views.view.ReactViewBackgroundManager;
import javax.annotation.Nullable;

public class ReactTextView
extends AppCompatTextView
implements ReactCompoundView {
    private static final ViewGroup.LayoutParams EMPTY_LAYOUT_PARAMS = new ViewGroup.LayoutParams(0, 0);
    private boolean mContainsImages;
    private int mDefaultGravityHorizontal;
    private int mDefaultGravityVertical;
    private int mTextAlign = 0;
    private int mNumberOfLines = Integer.MAX_VALUE;
    private TextUtils.TruncateAt mEllipsizeLocation = TextUtils.TruncateAt.END;
    private ReactViewBackgroundManager mReactBackgroundManager = new ReactViewBackgroundManager((View)this);
    private Spannable mSpanned;

    public ReactTextView(Context context) {
        super(context);
        this.mDefaultGravityHorizontal = this.getGravity() & 0x800007;
        this.mDefaultGravityVertical = this.getGravity() & 0x70;
    }

    public void setText(ReactTextUpdate update) {
        this.mContainsImages = update.containsImages();
        if (this.getLayoutParams() == null) {
            this.setLayoutParams(EMPTY_LAYOUT_PARAMS);
        }
        this.setText((CharSequence)update.getText());
        this.setPadding((int)Math.floor(update.getPaddingLeft()), (int)Math.floor(update.getPaddingTop()), (int)Math.floor(update.getPaddingRight()), (int)Math.floor(update.getPaddingBottom()));
        int nextTextAlign = update.getTextAlign();
        if (this.mTextAlign != nextTextAlign) {
            this.mTextAlign = nextTextAlign;
        }
        this.setGravityHorizontal(this.mTextAlign);
        if (Build.VERSION.SDK_INT >= 23 && this.getBreakStrategy() != update.getTextBreakStrategy()) {
            this.setBreakStrategy(update.getTextBreakStrategy());
        }
        if (Build.VERSION.SDK_INT >= 26 && this.getJustificationMode() != update.getJustificationMode()) {
            this.setJustificationMode(update.getJustificationMode());
        }
    }

    @Override
    public int reactTagForTouch(float touchX, float touchY) {
        CharSequence text = this.getText();
        int target = this.getId();
        int x = (int)touchX;
        int y = (int)touchY;
        Layout layout2 = this.getLayout();
        if (layout2 == null) {
            return target;
        }
        int line = layout2.getLineForVertical(y);
        int lineStartX = (int)layout2.getLineLeft(line);
        int lineEndX = (int)layout2.getLineRight(line);
        if (text instanceof Spanned && x >= lineStartX && x <= lineEndX) {
            Spanned spannedText = (Spanned)text;
            int index = -1;
            try {
                index = layout2.getOffsetForHorizontal(line, (float)x);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                FLog.e((String)"ReactNative", (String)("Crash in HorizontalMeasurementProvider: " + e.getMessage()));
                return target;
            }
            ReactTagSpan[] spans = (ReactTagSpan[])spannedText.getSpans(index, index, ReactTagSpan.class);
            if (spans != null) {
                int targetSpanTextLength = text.length();
                for (int i = 0; i < spans.length; ++i) {
                    int spanStart = spannedText.getSpanStart((Object)spans[i]);
                    int spanEnd = spannedText.getSpanEnd((Object)spans[i]);
                    if (spanEnd <= index || spanEnd - spanStart > targetSpanTextLength) continue;
                    target = spans[i].getReactTag();
                    targetSpanTextLength = spanEnd - spanStart;
                }
            }
        }
        return target;
    }

    protected boolean verifyDrawable(Drawable drawable) {
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                if (span.getDrawable() != drawable) continue;
                return true;
            }
        }
        return super.verifyDrawable(drawable);
    }

    public void invalidateDrawable(Drawable drawable) {
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                if (span.getDrawable() != drawable) continue;
                this.invalidate();
            }
        }
        super.invalidateDrawable(drawable);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onDetachedFromWindow();
            }
        }
    }

    public void onStartTemporaryDetach() {
        super.onStartTemporaryDetach();
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onStartTemporaryDetach();
            }
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onAttachedToWindow();
            }
        }
    }

    public void onFinishTemporaryDetach() {
        super.onFinishTemporaryDetach();
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onFinishTemporaryDetach();
            }
        }
    }

    public boolean hasOverlappingRendering() {
        return false;
    }

    void setGravityHorizontal(int gravityHorizontal) {
        if (gravityHorizontal == 0) {
            gravityHorizontal = this.mDefaultGravityHorizontal;
        }
        this.setGravity(this.getGravity() & 0xFFFFFFF8 & 0xFF7FFFF8 | gravityHorizontal);
    }

    void setGravityVertical(int gravityVertical) {
        if (gravityVertical == 0) {
            gravityVertical = this.mDefaultGravityVertical;
        }
        this.setGravity(this.getGravity() & 0xFFFFFF8F | gravityVertical);
    }

    public void setNumberOfLines(int numberOfLines) {
        this.mNumberOfLines = numberOfLines == 0 ? Integer.MAX_VALUE : numberOfLines;
        this.setSingleLine(this.mNumberOfLines == 1);
        this.setMaxLines(this.mNumberOfLines);
    }

    public void setEllipsizeLocation(TextUtils.TruncateAt ellipsizeLocation) {
        this.mEllipsizeLocation = ellipsizeLocation;
    }

    public void updateView() {
        TextUtils.TruncateAt ellipsizeLocation = this.mNumberOfLines == Integer.MAX_VALUE ? null : this.mEllipsizeLocation;
        this.setEllipsize(ellipsizeLocation);
    }

    public void setBackgroundColor(int color) {
        this.mReactBackgroundManager.setBackgroundColor(color);
    }

    public void setBorderWidth(int position, float width) {
        this.mReactBackgroundManager.setBorderWidth(position, width);
    }

    public void setBorderColor(int position, float color, float alpha) {
        this.mReactBackgroundManager.setBorderColor(position, color, alpha);
    }

    public void setBorderRadius(float borderRadius) {
        this.mReactBackgroundManager.setBorderRadius(borderRadius);
    }

    public void setBorderRadius(float borderRadius, int position) {
        this.mReactBackgroundManager.setBorderRadius(borderRadius, position);
    }

    public void setBorderStyle(@Nullable String style2) {
        this.mReactBackgroundManager.setBorderStyle(style2);
    }

    public void setSpanned(Spannable spanned) {
        this.mSpanned = spanned;
    }

    public Spannable getSpanned() {
        return this.mSpanned;
    }
}

