/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.module.annotations.ReactModule;
import javax.annotation.Nullable;
import javax.inject.Provider;

public class ModuleSpec {
    private static final String TAG = "ModuleSpec";
    @Nullable
    private final Class<? extends NativeModule> mType = null;
    private final Provider<? extends NativeModule> mProvider;
    private final String mName;

    public static ModuleSpec viewManagerSpec(Provider<? extends NativeModule> provider) {
        return new ModuleSpec(provider);
    }

    public static ModuleSpec nativeModuleSpec(Class<? extends NativeModule> type, Provider<? extends NativeModule> provider) {
        ReactModule annotation = type.getAnnotation(ReactModule.class);
        if (annotation == null) {
            FLog.w((String)TAG, (String)("Could not find @ReactModule annotation on " + type.getName() + ". So creating the module eagerly to get the name. Consider adding an annotation to make this Lazy"));
            NativeModule nativeModule = (NativeModule)provider.get();
            return new ModuleSpec(provider, nativeModule.getName());
        }
        return new ModuleSpec(provider, annotation.name());
    }

    public static ModuleSpec nativeModuleSpec(String className, Provider<? extends NativeModule> provider) {
        return new ModuleSpec(provider, className);
    }

    private ModuleSpec(Provider<? extends NativeModule> provider) {
        this.mProvider = provider;
        this.mName = null;
    }

    private ModuleSpec(Provider<? extends NativeModule> provider, String name) {
        this.mProvider = provider;
        this.mName = name;
    }

    @Nullable
    public Class<? extends NativeModule> getType() {
        return this.mType;
    }

    public String getName() {
        return this.mName;
    }

    public Provider<? extends NativeModule> getProvider() {
        return this.mProvider;
    }
}

