/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.statusbar;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.os.Build;
import android.view.View;
import android.view.WindowInsets;
import androidx.core.view.ViewCompat;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.GuardedRunnable;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.PixelUtil;
import java.util.Map;
import javax.annotation.Nullable;

@ReactModule(name="StatusBarManager")
public class StatusBarModule
extends ReactContextBaseJavaModule {
    private static final String HEIGHT_KEY = "HEIGHT";
    private static final String DEFAULT_BACKGROUND_COLOR_KEY = "DEFAULT_BACKGROUND_COLOR";
    public static final String NAME = "StatusBarManager";

    public StatusBarModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    @Nullable
    public Map<String, Object> getConstants() {
        ReactApplicationContext context = this.getReactApplicationContext();
        Activity activity = this.getCurrentActivity();
        int heightResId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        float height = heightResId > 0 ? PixelUtil.toDIPFromPixel(context.getResources().getDimensionPixelSize(heightResId)) : 0.0f;
        String statusBarColorString = "black";
        if (activity != null && Build.VERSION.SDK_INT >= 21) {
            int statusBarColor = activity.getWindow().getStatusBarColor();
            statusBarColorString = String.format("#%06X", 0xFFFFFF & statusBarColor);
        }
        return MapBuilder.of(HEIGHT_KEY, Float.valueOf(height), DEFAULT_BACKGROUND_COLOR_KEY, statusBarColorString);
    }

    @ReactMethod
    public void setColor(final int color, final boolean animated) {
        final Activity activity = this.getCurrentActivity();
        if (activity == null) {
            FLog.w((String)"ReactNative", (String)"StatusBarModule: Ignored status bar change, current activity is null.");
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            UiThreadUtil.runOnUiThread(new GuardedRunnable(this.getReactApplicationContext()){

                @Override
                @TargetApi(value=21)
                public void runGuarded() {
                    activity.getWindow().addFlags(Integer.MIN_VALUE);
                    if (animated) {
                        int curColor = activity.getWindow().getStatusBarColor();
                        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{curColor, color});
                        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                            public void onAnimationUpdate(ValueAnimator animator) {
                                activity.getWindow().setStatusBarColor(((Integer)animator.getAnimatedValue()).intValue());
                            }
                        });
                        colorAnimation.setDuration(300L).setStartDelay(0L);
                        colorAnimation.start();
                    } else {
                        activity.getWindow().setStatusBarColor(color);
                    }
                }
            });
        }
    }

    @ReactMethod
    public void setTranslucent(final boolean translucent) {
        final Activity activity = this.getCurrentActivity();
        if (activity == null) {
            FLog.w((String)"ReactNative", (String)"StatusBarModule: Ignored status bar change, current activity is null.");
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            UiThreadUtil.runOnUiThread(new GuardedRunnable(this.getReactApplicationContext()){

                @Override
                @TargetApi(value=21)
                public void runGuarded() {
                    View decorView = activity.getWindow().getDecorView();
                    if (translucent) {
                        decorView.setOnApplyWindowInsetsListener(new View.OnApplyWindowInsetsListener(){

                            public WindowInsets onApplyWindowInsets(View v, WindowInsets insets) {
                                WindowInsets defaultInsets = v.onApplyWindowInsets(insets);
                                return defaultInsets.replaceSystemWindowInsets(defaultInsets.getSystemWindowInsetLeft(), 0, defaultInsets.getSystemWindowInsetRight(), defaultInsets.getSystemWindowInsetBottom());
                            }
                        });
                    } else {
                        decorView.setOnApplyWindowInsetsListener(null);
                    }
                    ViewCompat.requestApplyInsets((View)decorView);
                }
            });
        }
    }

    @ReactMethod
    public void setHidden(final boolean hidden) {
        final Activity activity = this.getCurrentActivity();
        if (activity == null) {
            FLog.w((String)"ReactNative", (String)"StatusBarModule: Ignored status bar change, current activity is null.");
            return;
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (hidden) {
                    activity.getWindow().addFlags(1024);
                    activity.getWindow().clearFlags(2048);
                } else {
                    activity.getWindow().addFlags(2048);
                    activity.getWindow().clearFlags(1024);
                }
            }
        });
    }

    @ReactMethod
    public void setStyle(final @Nullable String style2) {
        final Activity activity = this.getCurrentActivity();
        if (activity == null) {
            FLog.w((String)"ReactNative", (String)"StatusBarModule: Ignored status bar change, current activity is null.");
            return;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            UiThreadUtil.runOnUiThread(new Runnable(){

                @Override
                @TargetApi(value=23)
                public void run() {
                    View decorView = activity.getWindow().getDecorView();
                    int systemUiVisibilityFlags = decorView.getSystemUiVisibility();
                    systemUiVisibilityFlags = "dark-content".equals(style2) ? (systemUiVisibilityFlags |= 0x2000) : (systemUiVisibilityFlags &= 0xFFFFDFFF);
                    decorView.setSystemUiVisibility(systemUiVisibilityFlags);
                }
            });
        }
    }
}

