/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import androidx.annotation.NonNull;
import com.facebook.react.ReactPackage;
import com.facebook.react.bridge.ModuleHolder;
import com.facebook.react.bridge.ModuleSpec;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.module.model.ReactModuleInfo;
import com.facebook.react.module.model.ReactModuleInfoProvider;
import com.facebook.react.uimanager.ViewManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;

public abstract class TurboReactPackage
implements ReactPackage {
    @Override
    public List<NativeModule> createNativeModules(ReactApplicationContext reactContext) {
        throw new UnsupportedOperationException("In case of TurboModules, createNativeModules is not supported. NativeModuleRegistry should instead use getModuleList or getModule method");
    }

    public abstract NativeModule getModule(String var1, ReactApplicationContext var2);

    public Iterable<ModuleHolder> getNativeModuleIterator(final ReactApplicationContext reactContext) {
        Set<Map.Entry<String, ReactModuleInfo>> entrySet = this.getReactModuleInfoProvider().getReactModuleInfos().entrySet();
        final Iterator<Map.Entry<String, ReactModuleInfo>> entrySetIterator = entrySet.iterator();
        return new Iterable<ModuleHolder>(){

            @Override
            @NonNull
            public Iterator<ModuleHolder> iterator() {
                return new Iterator<ModuleHolder>(){

                    @Override
                    public boolean hasNext() {
                        return entrySetIterator.hasNext();
                    }

                    @Override
                    public ModuleHolder next() {
                        Map.Entry entry = (Map.Entry)entrySetIterator.next();
                        String name = (String)entry.getKey();
                        ReactModuleInfo reactModuleInfo = (ReactModuleInfo)entry.getValue();
                        return new ModuleHolder(reactModuleInfo, new ModuleHolderProvider(name, reactContext));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Cannot remove native modules from the list");
                    }
                };
            }
        };
    }

    protected List<ModuleSpec> getViewManagers(ReactApplicationContext reactContext) {
        return Collections.emptyList();
    }

    @Override
    public List<ViewManager> createViewManagers(ReactApplicationContext reactContext) {
        List<ModuleSpec> viewManagerModuleSpecs = this.getViewManagers(reactContext);
        if (viewManagerModuleSpecs == null || viewManagerModuleSpecs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ViewManager> viewManagers = new ArrayList<ViewManager>();
        for (ModuleSpec moduleSpec : viewManagerModuleSpecs) {
            viewManagers.add((ViewManager)moduleSpec.getProvider().get());
        }
        return viewManagers;
    }

    public abstract ReactModuleInfoProvider getReactModuleInfoProvider();

    private class ModuleHolderProvider
    implements Provider<NativeModule> {
        private final String mName;
        private final ReactApplicationContext mReactContext;

        public ModuleHolderProvider(String name, ReactApplicationContext reactContext) {
            this.mName = name;
            this.mReactContext = reactContext;
        }

        public NativeModule get() {
            return TurboReactPackage.this.getModule(this.mName, this.mReactContext);
        }
    }
}

