/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.react.bridge.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

class JsonWriterHelper {
    JsonWriterHelper() {
    }

    public static void value(JsonWriter writer, Object value) throws IOException {
        if (value instanceof Map) {
            JsonWriterHelper.mapValue(writer, (Map)value);
        } else if (value instanceof List) {
            JsonWriterHelper.listValue(writer, (List)value);
        } else {
            JsonWriterHelper.objectValue(writer, value);
        }
    }

    private static void mapValue(JsonWriter writer, Map<?, ?> map) throws IOException {
        writer.beginObject();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            writer.name(entry.getKey().toString());
            JsonWriterHelper.value(writer, entry.getValue());
        }
        writer.endObject();
    }

    private static void listValue(JsonWriter writer, List<?> list) throws IOException {
        writer.beginArray();
        for (Object item : list) {
            JsonWriterHelper.objectValue(writer, item);
        }
        writer.endArray();
    }

    private static void objectValue(JsonWriter writer, Object value) throws IOException {
        if (value == null) {
            writer.nullValue();
        } else if (value instanceof String) {
            writer.value((String)value);
        } else if (value instanceof Number) {
            writer.value((Number)value);
        } else if (value instanceof Boolean) {
            writer.value((Boolean)value);
        } else {
            throw new IllegalArgumentException("Unknown value: " + value);
        }
    }
}

