/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.util.TypedValue;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.SoftAssertions;

public class ReactDrawableHelper {
    private static final TypedValue sResolveOutValue = new TypedValue();

    @TargetApi(value=21)
    public static Drawable createDrawableFromJSDescription(Context context, ReadableMap drawableDescriptionDict) {
        String type = drawableDescriptionDict.getString("type");
        if ("ThemeAttrAndroid".equals(type)) {
            String attr2 = drawableDescriptionDict.getString("attribute");
            SoftAssertions.assertNotNull(attr2);
            int attrID = context.getResources().getIdentifier(attr2, "attr", "android");
            if (attrID == 0) {
                throw new JSApplicationIllegalArgumentException("Attribute " + attr2 + " couldn't be found in the resource list");
            }
            if (context.getTheme().resolveAttribute(attrID, sResolveOutValue, true)) {
                if (Build.VERSION.SDK_INT >= 21) {
                    return context.getResources().getDrawable(ReactDrawableHelper.sResolveOutValue.resourceId, context.getTheme());
                }
                return context.getResources().getDrawable(ReactDrawableHelper.sResolveOutValue.resourceId);
            }
            throw new JSApplicationIllegalArgumentException("Attribute " + attr2 + " couldn't be resolved into a drawable");
        }
        if ("RippleAndroid".equals(type)) {
            int color;
            if (Build.VERSION.SDK_INT < 21) {
                throw new JSApplicationIllegalArgumentException("Ripple drawable is not available on android API <21");
            }
            if (drawableDescriptionDict.hasKey("color") && !drawableDescriptionDict.isNull("color")) {
                color = drawableDescriptionDict.getInt("color");
            } else if (context.getTheme().resolveAttribute(16843820, sResolveOutValue, true)) {
                color = context.getResources().getColor(ReactDrawableHelper.sResolveOutValue.resourceId);
            } else {
                throw new JSApplicationIllegalArgumentException("Attribute colorControlHighlight couldn't be resolved into a drawable");
            }
            ColorDrawable mask = null;
            if (!drawableDescriptionDict.hasKey("borderless") || drawableDescriptionDict.isNull("borderless") || !drawableDescriptionDict.getBoolean("borderless")) {
                mask = new ColorDrawable(-1);
            }
            ColorStateList colorStateList = new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{color});
            return new RippleDrawable(colorStateList, null, (Drawable)mask);
        }
        throw new JSApplicationIllegalArgumentException("Invalid type for android drawable: " + type);
    }
}

