/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactShadowNodeImpl;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.text.CustomLetterSpacingSpan;
import com.facebook.react.views.text.CustomLineHeightSpan;
import com.facebook.react.views.text.CustomStyleSpan;
import com.facebook.react.views.text.ReactAbsoluteSizeSpan;
import com.facebook.react.views.text.ReactBackgroundColorSpan;
import com.facebook.react.views.text.ReactForegroundColorSpan;
import com.facebook.react.views.text.ReactRawTextShadowNode;
import com.facebook.react.views.text.ReactSpan;
import com.facebook.react.views.text.ReactStrikethroughSpan;
import com.facebook.react.views.text.ReactTagSpan;
import com.facebook.react.views.text.ReactTextInlineImageShadowNode;
import com.facebook.react.views.text.ReactUnderlineSpan;
import com.facebook.react.views.text.ShadowStyleSpan;
import com.facebook.react.views.text.TextAttributes;
import com.facebook.react.views.text.TextInlineImageSpan;
import com.facebook.react.views.text.TextTransform;
import com.facebook.yoga.YogaDirection;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@TargetApi(value=23)
public abstract class ReactBaseTextShadowNode
extends LayoutShadowNode {
    private static final String INLINE_IMAGE_PLACEHOLDER = "I";
    public static final int UNSET = -1;
    public static final String PROP_SHADOW_OFFSET = "textShadowOffset";
    public static final String PROP_SHADOW_OFFSET_WIDTH = "width";
    public static final String PROP_SHADOW_OFFSET_HEIGHT = "height";
    public static final String PROP_SHADOW_RADIUS = "textShadowRadius";
    public static final String PROP_SHADOW_COLOR = "textShadowColor";
    public static final String PROP_TEXT_TRANSFORM = "textTransform";
    public static final int DEFAULT_TEXT_SHADOW_COLOR = 0x55000000;
    protected TextAttributes mTextAttributes;
    protected boolean mIsColorSet = false;
    protected int mColor;
    protected boolean mIsBackgroundColorSet = false;
    protected int mBackgroundColor;
    protected int mNumberOfLines = -1;
    protected int mTextAlign = 0;
    protected int mTextBreakStrategy = Build.VERSION.SDK_INT < 23 ? 0 : 1;
    protected int mJustificationMode = Build.VERSION.SDK_INT < 26 ? 0 : 0;
    protected TextTransform mTextTransform = TextTransform.UNSET;
    protected float mTextShadowOffsetDx = 0.0f;
    protected float mTextShadowOffsetDy = 0.0f;
    protected float mTextShadowRadius = 0.0f;
    protected int mTextShadowColor = 0x55000000;
    protected boolean mIsUnderlineTextDecorationSet = false;
    protected boolean mIsLineThroughTextDecorationSet = false;
    protected boolean mIncludeFontPadding = true;
    protected int mFontStyle = -1;
    protected int mFontWeight = -1;
    @Nullable
    protected String mFontFamily = null;
    protected boolean mContainsImages = false;
    protected float mHeightOfTallestInlineImage = Float.NaN;

    private static void buildSpannedFromShadowNode(ReactBaseTextShadowNode textShadowNode, SpannableStringBuilder sb, List<SetSpanOperation> ops, TextAttributes parentTextAttributes, int start) {
        TextAttributes textAttributes = parentTextAttributes != null ? parentTextAttributes.applyChild(textShadowNode.mTextAttributes) : textShadowNode.mTextAttributes;
        int length = textShadowNode.getChildCount();
        for (int i = 0; i < length; ++i) {
            ReactShadowNodeImpl child = textShadowNode.getChildAt(i);
            if (child instanceof ReactRawTextShadowNode) {
                sb.append((CharSequence)TextTransform.apply(((ReactRawTextShadowNode)child).getText(), textAttributes.getTextTransform()));
            } else if (child instanceof ReactBaseTextShadowNode) {
                ReactBaseTextShadowNode.buildSpannedFromShadowNode((ReactBaseTextShadowNode)child, sb, ops, textAttributes, sb.length());
            } else if (child instanceof ReactTextInlineImageShadowNode) {
                sb.append((CharSequence)INLINE_IMAGE_PLACEHOLDER);
                ops.add(new SetSpanOperation(sb.length() - INLINE_IMAGE_PLACEHOLDER.length(), sb.length(), ((ReactTextInlineImageShadowNode)child).buildInlineImageSpan()));
            } else {
                throw new IllegalViewOperationException("Unexpected view type nested under text node: " + child.getClass());
            }
            child.markUpdateSeen();
        }
        int end = sb.length();
        if (end >= start) {
            float effectiveLineHeight;
            float effectiveLetterSpacing;
            if (textShadowNode.mIsColorSet) {
                ops.add(new SetSpanOperation(start, end, new ReactForegroundColorSpan(textShadowNode.mColor)));
            }
            if (textShadowNode.mIsBackgroundColorSet) {
                ops.add(new SetSpanOperation(start, end, new ReactBackgroundColorSpan(textShadowNode.mBackgroundColor)));
            }
            if (!(Build.VERSION.SDK_INT < 21 || Float.isNaN(effectiveLetterSpacing = textAttributes.getEffectiveLetterSpacing()) || parentTextAttributes != null && parentTextAttributes.getEffectiveLetterSpacing() == effectiveLetterSpacing)) {
                ops.add(new SetSpanOperation(start, end, new CustomLetterSpacingSpan(effectiveLetterSpacing)));
            }
            int effectiveFontSize = textAttributes.getEffectiveFontSize();
            if (parentTextAttributes == null || parentTextAttributes.getEffectiveFontSize() != effectiveFontSize) {
                ops.add(new SetSpanOperation(start, end, new ReactAbsoluteSizeSpan(effectiveFontSize)));
            }
            if (textShadowNode.mFontStyle != -1 || textShadowNode.mFontWeight != -1 || textShadowNode.mFontFamily != null) {
                ops.add(new SetSpanOperation(start, end, new CustomStyleSpan(textShadowNode.mFontStyle, textShadowNode.mFontWeight, textShadowNode.mFontFamily, (Context)textShadowNode.getThemedContext(), textShadowNode.getThemedContext().getAssets())));
            }
            if (textShadowNode.mIsUnderlineTextDecorationSet) {
                ops.add(new SetSpanOperation(start, end, new ReactUnderlineSpan()));
            }
            if (textShadowNode.mIsLineThroughTextDecorationSet) {
                ops.add(new SetSpanOperation(start, end, new ReactStrikethroughSpan()));
            }
            if ((textShadowNode.mTextShadowOffsetDx != 0.0f || textShadowNode.mTextShadowOffsetDy != 0.0f || textShadowNode.mTextShadowRadius != 0.0f) && Color.alpha((int)textShadowNode.mTextShadowColor) != 0) {
                ops.add(new SetSpanOperation(start, end, new ShadowStyleSpan(textShadowNode.mTextShadowOffsetDx, textShadowNode.mTextShadowOffsetDy, textShadowNode.mTextShadowRadius, textShadowNode.mTextShadowColor)));
            }
            if (!(Float.isNaN(effectiveLineHeight = textAttributes.getEffectiveLineHeight()) || parentTextAttributes != null && parentTextAttributes.getEffectiveLineHeight() == effectiveLineHeight)) {
                ops.add(new SetSpanOperation(start, end, new CustomLineHeightSpan(effectiveLineHeight)));
            }
            ops.add(new SetSpanOperation(start, end, new ReactTagSpan(textShadowNode.getReactTag())));
        }
    }

    protected static Spannable spannedFromShadowNode(ReactBaseTextShadowNode textShadowNode, String text) {
        SpannableStringBuilder sb = new SpannableStringBuilder();
        ArrayList<SetSpanOperation> ops = new ArrayList<SetSpanOperation>();
        if (text != null) {
            sb.append((CharSequence)TextTransform.apply(text, textShadowNode.mTextAttributes.getTextTransform()));
        }
        ReactBaseTextShadowNode.buildSpannedFromShadowNode(textShadowNode, sb, ops, null, 0);
        textShadowNode.mContainsImages = false;
        float heightOfTallestInlineImage = Float.NaN;
        int priority = 0;
        for (SetSpanOperation op : ops) {
            if (op.what instanceof TextInlineImageSpan) {
                int height = ((TextInlineImageSpan)op.what).getHeight();
                textShadowNode.mContainsImages = true;
                if (Float.isNaN(heightOfTallestInlineImage) || (float)height > heightOfTallestInlineImage) {
                    heightOfTallestInlineImage = height;
                }
            }
            op.execute(sb, priority);
            ++priority;
        }
        textShadowNode.mTextAttributes.setHeightOfTallestInlineImage(heightOfTallestInlineImage);
        return sb;
    }

    private static int parseNumericFontWeight(String fontWeightString) {
        return fontWeightString.length() == 3 && fontWeightString.endsWith("00") && fontWeightString.charAt(0) <= '9' && fontWeightString.charAt(0) >= '1' ? 100 * (fontWeightString.charAt(0) - 48) : -1;
    }

    public ReactBaseTextShadowNode() {
        this.mTextAttributes = new TextAttributes();
    }

    private int getTextAlign() {
        int textAlign = this.mTextAlign;
        if (this.getLayoutDirection() == YogaDirection.RTL) {
            if (textAlign == 5) {
                textAlign = 3;
            } else if (textAlign == 3) {
                textAlign = 5;
            }
        }
        return textAlign;
    }

    @ReactProp(name="numberOfLines", defaultInt=-1)
    public void setNumberOfLines(int numberOfLines) {
        this.mNumberOfLines = numberOfLines == 0 ? -1 : numberOfLines;
        this.markUpdated();
    }

    @ReactProp(name="lineHeight", defaultFloat=NaNf)
    public void setLineHeight(float lineHeight) {
        this.mTextAttributes.setLineHeight(lineHeight);
        this.markUpdated();
    }

    @ReactProp(name="letterSpacing", defaultFloat=NaNf)
    public void setLetterSpacing(float letterSpacing) {
        this.mTextAttributes.setLetterSpacing(letterSpacing);
        this.markUpdated();
    }

    @ReactProp(name="allowFontScaling", defaultBoolean=true)
    public void setAllowFontScaling(boolean allowFontScaling) {
        if (allowFontScaling != this.mTextAttributes.getAllowFontScaling()) {
            this.mTextAttributes.setAllowFontScaling(allowFontScaling);
            this.markUpdated();
        }
    }

    @ReactProp(name="maxFontSizeMultiplier", defaultFloat=NaNf)
    public void setMaxFontSizeMultiplier(float maxFontSizeMultiplier) {
        if (maxFontSizeMultiplier != this.mTextAttributes.getMaxFontSizeMultiplier()) {
            this.mTextAttributes.setMaxFontSizeMultiplier(maxFontSizeMultiplier);
            this.markUpdated();
        }
    }

    @ReactProp(name="textAlign")
    public void setTextAlign(@Nullable String textAlign) {
        if ("justify".equals(textAlign)) {
            if (Build.VERSION.SDK_INT >= 26) {
                this.mJustificationMode = 1;
            }
            this.mTextAlign = 3;
        } else {
            if (Build.VERSION.SDK_INT >= 26) {
                this.mJustificationMode = 0;
            }
            if (textAlign == null || "auto".equals(textAlign)) {
                this.mTextAlign = 0;
            } else if ("left".equals(textAlign)) {
                this.mTextAlign = 3;
            } else if ("right".equals(textAlign)) {
                this.mTextAlign = 5;
            } else if ("center".equals(textAlign)) {
                this.mTextAlign = 1;
            } else {
                throw new JSApplicationIllegalArgumentException("Invalid textAlign: " + textAlign);
            }
        }
        this.markUpdated();
    }

    @ReactProp(name="fontSize", defaultFloat=NaNf)
    public void setFontSize(float fontSize) {
        this.mTextAttributes.setFontSize(fontSize);
        this.markUpdated();
    }

    @ReactProp(name="color")
    public void setColor(@Nullable Integer color) {
        boolean bl = this.mIsColorSet = color != null;
        if (this.mIsColorSet) {
            this.mColor = color;
        }
        this.markUpdated();
    }

    @ReactProp(name="backgroundColor")
    public void setBackgroundColor(Integer color) {
        if (!this.isVirtualAnchor()) {
            boolean bl = this.mIsBackgroundColorSet = color != null;
            if (this.mIsBackgroundColorSet) {
                this.mBackgroundColor = color;
            }
            this.markUpdated();
        }
    }

    @ReactProp(name="fontFamily")
    public void setFontFamily(@Nullable String fontFamily) {
        this.mFontFamily = fontFamily;
        this.markUpdated();
    }

    @ReactProp(name="fontWeight")
    public void setFontWeight(@Nullable String fontWeightString) {
        int fontWeightNumeric = fontWeightString != null ? ReactBaseTextShadowNode.parseNumericFontWeight(fontWeightString) : -1;
        int fontWeight = -1;
        if (fontWeightNumeric >= 500 || "bold".equals(fontWeightString)) {
            fontWeight = 1;
        } else if ("normal".equals(fontWeightString) || fontWeightNumeric != -1 && fontWeightNumeric < 500) {
            fontWeight = 0;
        }
        if (fontWeight != this.mFontWeight) {
            this.mFontWeight = fontWeight;
            this.markUpdated();
        }
    }

    @ReactProp(name="fontStyle")
    public void setFontStyle(@Nullable String fontStyleString) {
        int fontStyle = -1;
        if ("italic".equals(fontStyleString)) {
            fontStyle = 2;
        } else if ("normal".equals(fontStyleString)) {
            fontStyle = 0;
        }
        if (fontStyle != this.mFontStyle) {
            this.mFontStyle = fontStyle;
            this.markUpdated();
        }
    }

    @ReactProp(name="includeFontPadding", defaultBoolean=true)
    public void setIncludeFontPadding(boolean includepad) {
        this.mIncludeFontPadding = includepad;
    }

    @ReactProp(name="textDecorationLine")
    public void setTextDecorationLine(@Nullable String textDecorationLineString) {
        this.mIsUnderlineTextDecorationSet = false;
        this.mIsLineThroughTextDecorationSet = false;
        if (textDecorationLineString != null) {
            for (String textDecorationLineSubString : textDecorationLineString.split(" ")) {
                if ("underline".equals(textDecorationLineSubString)) {
                    this.mIsUnderlineTextDecorationSet = true;
                    continue;
                }
                if (!"line-through".equals(textDecorationLineSubString)) continue;
                this.mIsLineThroughTextDecorationSet = true;
            }
        }
        this.markUpdated();
    }

    @ReactProp(name="textBreakStrategy")
    public void setTextBreakStrategy(@Nullable String textBreakStrategy) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        if (textBreakStrategy == null || "highQuality".equals(textBreakStrategy)) {
            this.mTextBreakStrategy = 1;
        } else if ("simple".equals(textBreakStrategy)) {
            this.mTextBreakStrategy = 0;
        } else if ("balanced".equals(textBreakStrategy)) {
            this.mTextBreakStrategy = 2;
        } else {
            throw new JSApplicationIllegalArgumentException("Invalid textBreakStrategy: " + textBreakStrategy);
        }
        this.markUpdated();
    }

    @ReactProp(name="textShadowOffset")
    public void setTextShadowOffset(ReadableMap offsetMap) {
        this.mTextShadowOffsetDx = 0.0f;
        this.mTextShadowOffsetDy = 0.0f;
        if (offsetMap != null) {
            if (offsetMap.hasKey(PROP_SHADOW_OFFSET_WIDTH) && !offsetMap.isNull(PROP_SHADOW_OFFSET_WIDTH)) {
                this.mTextShadowOffsetDx = PixelUtil.toPixelFromDIP(offsetMap.getDouble(PROP_SHADOW_OFFSET_WIDTH));
            }
            if (offsetMap.hasKey(PROP_SHADOW_OFFSET_HEIGHT) && !offsetMap.isNull(PROP_SHADOW_OFFSET_HEIGHT)) {
                this.mTextShadowOffsetDy = PixelUtil.toPixelFromDIP(offsetMap.getDouble(PROP_SHADOW_OFFSET_HEIGHT));
            }
        }
        this.markUpdated();
    }

    @ReactProp(name="textShadowRadius", defaultInt=1)
    public void setTextShadowRadius(float textShadowRadius) {
        if (textShadowRadius != this.mTextShadowRadius) {
            this.mTextShadowRadius = textShadowRadius;
            this.markUpdated();
        }
    }

    @ReactProp(name="textShadowColor", defaultInt=0x55000000, customType="Color")
    public void setTextShadowColor(int textShadowColor) {
        if (textShadowColor != this.mTextShadowColor) {
            this.mTextShadowColor = textShadowColor;
            this.markUpdated();
        }
    }

    @ReactProp(name="textTransform")
    public void setTextTransform(@Nullable String textTransform) {
        if (textTransform == null) {
            this.mTextAttributes.setTextTransform(TextTransform.UNSET);
        } else if ("none".equals(textTransform)) {
            this.mTextAttributes.setTextTransform(TextTransform.NONE);
        } else if ("uppercase".equals(textTransform)) {
            this.mTextAttributes.setTextTransform(TextTransform.UPPERCASE);
        } else if ("lowercase".equals(textTransform)) {
            this.mTextAttributes.setTextTransform(TextTransform.LOWERCASE);
        } else if ("capitalize".equals(textTransform)) {
            this.mTextAttributes.setTextTransform(TextTransform.CAPITALIZE);
        } else {
            throw new JSApplicationIllegalArgumentException("Invalid textTransform: " + textTransform);
        }
        this.markUpdated();
    }

    private static class SetSpanOperation {
        protected int start;
        protected int end;
        protected ReactSpan what;

        SetSpanOperation(int start, int end, ReactSpan what) {
            this.start = start;
            this.end = end;
            this.what = what;
        }

        public void execute(SpannableStringBuilder sb, int priority) {
            int spanFlags = 34;
            if (this.start == 0) {
                spanFlags = 18;
            }
            spanFlags &= 0xFF00FFFF;
            sb.setSpan((Object)this.what, this.start, this.end, spanFlags |= priority << 16 & 0xFF0000);
        }
    }
}

