/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.blob;

import android.content.res.Resources;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.webkit.MimeTypeMap;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.network.NetworkingModule;
import com.facebook.react.modules.websocket.WebSocketModule;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okio.ByteString;

@ReactModule(name="BlobModule")
public class BlobModule
extends ReactContextBaseJavaModule {
    protected static final String NAME = "BlobModule";
    private final Map<String, byte[]> mBlobs = new HashMap<String, byte[]>();
    private final WebSocketModule.ContentHandler mWebSocketContentHandler = new WebSocketModule.ContentHandler(){

        @Override
        public void onMessage(String text, WritableMap params) {
            params.putString("data", text);
        }

        @Override
        public void onMessage(ByteString bytes, WritableMap params) {
            byte[] data = bytes.toByteArray();
            WritableMap blob = Arguments.createMap();
            blob.putString("blobId", BlobModule.this.store(data));
            blob.putInt("offset", 0);
            blob.putInt("size", data.length);
            params.putMap("data", blob);
            params.putString("type", "blob");
        }
    };
    private final NetworkingModule.UriHandler mNetworkingUriHandler = new NetworkingModule.UriHandler(){

        @Override
        public boolean supports(Uri uri, String responseType) {
            String scheme = uri.getScheme();
            boolean isRemote = "http".equals(scheme) || "https".equals(scheme);
            return !isRemote && "blob".equals(responseType);
        }

        @Override
        public WritableMap fetch(Uri uri) throws IOException {
            byte[] data = BlobModule.this.getBytesFromUri(uri);
            WritableMap blob = Arguments.createMap();
            blob.putString("blobId", BlobModule.this.store(data));
            blob.putInt("offset", 0);
            blob.putInt("size", data.length);
            blob.putString("type", BlobModule.this.getMimeTypeFromUri(uri));
            blob.putString("name", BlobModule.this.getNameFromUri(uri));
            blob.putDouble("lastModified", BlobModule.this.getLastModifiedFromUri(uri));
            return blob;
        }
    };
    private final NetworkingModule.RequestBodyHandler mNetworkingRequestBodyHandler = new NetworkingModule.RequestBodyHandler(){

        @Override
        public boolean supports(ReadableMap data) {
            return data.hasKey("blob");
        }

        @Override
        public RequestBody toRequestBody(ReadableMap data, String contentType) {
            String type = contentType;
            if (data.hasKey("type") && !data.getString("type").isEmpty()) {
                type = data.getString("type");
            }
            if (type == null) {
                type = "application/octet-stream";
            }
            ReadableMap blob = data.getMap("blob");
            String blobId = blob.getString("blobId");
            byte[] bytes = BlobModule.this.resolve(blobId, blob.getInt("offset"), blob.getInt("size"));
            return RequestBody.create((MediaType)MediaType.parse((String)type), (byte[])bytes);
        }
    };
    private final NetworkingModule.ResponseHandler mNetworkingResponseHandler = new NetworkingModule.ResponseHandler(){

        @Override
        public boolean supports(String responseType) {
            return "blob".equals(responseType);
        }

        @Override
        public WritableMap toResponseData(ResponseBody body) throws IOException {
            byte[] data = body.bytes();
            WritableMap blob = Arguments.createMap();
            blob.putString("blobId", BlobModule.this.store(data));
            blob.putInt("offset", 0);
            blob.putInt("size", data.length);
            return blob;
        }
    };

    public BlobModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    @Nullable
    public Map<String, Object> getConstants() {
        String packageName;
        Resources resources = this.getReactApplicationContext().getResources();
        int resourceId = resources.getIdentifier("blob_provider_authority", "string", packageName = this.getReactApplicationContext().getPackageName());
        if (resourceId == 0) {
            return null;
        }
        return MapBuilder.of("BLOB_URI_SCHEME", "content", "BLOB_URI_HOST", resources.getString(resourceId));
    }

    public String store(byte[] data) {
        String blobId = UUID.randomUUID().toString();
        this.store(data, blobId);
        return blobId;
    }

    public void store(byte[] data, String blobId) {
        this.mBlobs.put(blobId, data);
    }

    public void remove(String blobId) {
        this.mBlobs.remove(blobId);
    }

    @Nullable
    public byte[] resolve(Uri uri) {
        String sizeParam;
        String blobId = uri.getLastPathSegment();
        int offset = 0;
        int size = -1;
        String offsetParam = uri.getQueryParameter("offset");
        if (offsetParam != null) {
            offset = Integer.parseInt(offsetParam, 10);
        }
        if ((sizeParam = uri.getQueryParameter("size")) != null) {
            size = Integer.parseInt(sizeParam, 10);
        }
        return this.resolve(blobId, offset, size);
    }

    @Nullable
    public byte[] resolve(String blobId, int offset, int size) {
        byte[] data = this.mBlobs.get(blobId);
        if (data == null) {
            return null;
        }
        if (size == -1) {
            size = data.length - offset;
        }
        if (offset > 0 || size != data.length) {
            data = Arrays.copyOfRange(data, offset, offset + size);
        }
        return data;
    }

    @Nullable
    public byte[] resolve(ReadableMap blob) {
        return this.resolve(blob.getString("blobId"), blob.getInt("offset"), blob.getInt("size"));
    }

    private byte[] getBytesFromUri(Uri contentUri) throws IOException {
        int len;
        InputStream is = this.getReactApplicationContext().getContentResolver().openInputStream(contentUri);
        if (is == null) {
            throw new FileNotFoundException("File not found for " + contentUri);
        }
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        while ((len = is.read(buffer)) != -1) {
            byteBuffer.write(buffer, 0, len);
        }
        return byteBuffer.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNameFromUri(Uri contentUri) {
        if ("file".equals(contentUri.getScheme())) {
            return contentUri.getLastPathSegment();
        }
        String[] projection = new String[]{"_display_name"};
        Cursor metaCursor = this.getReactApplicationContext().getContentResolver().query(contentUri, projection, null, null, null);
        if (metaCursor != null) {
            try {
                if (metaCursor.moveToFirst()) {
                    String string2 = metaCursor.getString(0);
                    return string2;
                }
            }
            finally {
                metaCursor.close();
            }
        }
        return contentUri.getLastPathSegment();
    }

    private long getLastModifiedFromUri(Uri contentUri) {
        if ("file".equals(contentUri.getScheme())) {
            return new File(contentUri.toString()).lastModified();
        }
        return 0L;
    }

    private String getMimeTypeFromUri(Uri contentUri) {
        String ext;
        String type = this.getReactApplicationContext().getContentResolver().getType(contentUri);
        if (type == null && (ext = MimeTypeMap.getFileExtensionFromUrl((String)contentUri.getPath())) != null) {
            type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(ext);
        }
        if (type == null) {
            type = "";
        }
        return type;
    }

    private WebSocketModule getWebSocketModule() {
        return this.getReactApplicationContext().getNativeModule(WebSocketModule.class);
    }

    @ReactMethod
    public void addNetworkingHandler() {
        NetworkingModule networkingModule = this.getReactApplicationContext().getNativeModule(NetworkingModule.class);
        if (networkingModule == null) {
            return;
        }
        networkingModule.addUriHandler(this.mNetworkingUriHandler);
        networkingModule.addRequestBodyHandler(this.mNetworkingRequestBodyHandler);
        networkingModule.addResponseHandler(this.mNetworkingResponseHandler);
    }

    @ReactMethod
    public void addWebSocketHandler(int id2) {
        WebSocketModule module = this.getWebSocketModule();
        if (module == null) {
            return;
        }
        module.setContentHandler(id2, this.mWebSocketContentHandler);
    }

    @ReactMethod
    public void removeWebSocketHandler(int id2) {
        WebSocketModule module = this.getWebSocketModule();
        if (module == null) {
            return;
        }
        module.setContentHandler(id2, null);
    }

    @ReactMethod
    public void sendOverSocket(ReadableMap blob, int id2) {
        byte[] data = this.resolve(blob.getString("blobId"), blob.getInt("offset"), blob.getInt("size"));
        WebSocketModule module = this.getWebSocketModule();
        if (module == null) {
            return;
        }
        if (data != null) {
            module.sendBinary(ByteString.of((byte[])data), id2);
        } else {
            module.sendBinary((ByteString)null, id2);
        }
    }

    @ReactMethod
    public void createFromParts(ReadableArray parts, String blobId) {
        int totalBlobSize = 0;
        ArrayList<byte[]> partList = new ArrayList<byte[]>(parts.size());
        block8: for (int i = 0; i < parts.size(); ++i) {
            ReadableMap part = parts.getMap(i);
            switch (part.getString("type")) {
                case "blob": {
                    ReadableMap blob = part.getMap("data");
                    totalBlobSize += blob.getInt("size");
                    partList.add(i, this.resolve(blob));
                    continue block8;
                }
                case "string": {
                    byte[] bytes = part.getString("data").getBytes(Charset.forName("UTF-8"));
                    totalBlobSize += bytes.length;
                    partList.add(i, bytes);
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Invalid type for blob: " + part.getString("type"));
                }
            }
        }
        ByteBuffer buffer = ByteBuffer.allocate(totalBlobSize);
        for (byte[] bytes : partList) {
            buffer.put(bytes);
        }
        this.store(buffer.array(), blobId);
    }

    @ReactMethod
    public void release(String blobId) {
        this.remove(blobId);
    }
}

