/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.yoga;

import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.soloader.SoLoader;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaBaselineFunction;
import com.facebook.yoga.YogaConfig;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaDisplay;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaFlexDirection;
import com.facebook.yoga.YogaJustify;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaOverflow;
import com.facebook.yoga.YogaPositionType;
import com.facebook.yoga.YogaValue;
import com.facebook.yoga.YogaWrap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@DoNotStrip
public class YogaNode
implements Cloneable {
    private YogaNode mOwner;
    @Nullable
    private List<YogaNode> mChildren;
    private YogaMeasureFunction mMeasureFunction;
    private YogaBaselineFunction mBaselineFunction;
    private long mNativePointer;
    private Object mData;
    private static final int MARGIN = 1;
    private static final int PADDING = 2;
    private static final int BORDER = 4;
    @DoNotStrip
    private int mEdgeSetFlag = 0;
    private boolean mHasSetPosition = false;
    @DoNotStrip
    private float mWidth = Float.NaN;
    @DoNotStrip
    private float mHeight = Float.NaN;
    @DoNotStrip
    private float mTop = Float.NaN;
    @DoNotStrip
    private float mLeft = Float.NaN;
    @DoNotStrip
    private float mMarginLeft = 0.0f;
    @DoNotStrip
    private float mMarginTop = 0.0f;
    @DoNotStrip
    private float mMarginRight = 0.0f;
    @DoNotStrip
    private float mMarginBottom = 0.0f;
    @DoNotStrip
    private float mPaddingLeft = 0.0f;
    @DoNotStrip
    private float mPaddingTop = 0.0f;
    @DoNotStrip
    private float mPaddingRight = 0.0f;
    @DoNotStrip
    private float mPaddingBottom = 0.0f;
    @DoNotStrip
    private float mBorderLeft = 0.0f;
    @DoNotStrip
    private float mBorderTop = 0.0f;
    @DoNotStrip
    private float mBorderRight = 0.0f;
    @DoNotStrip
    private float mBorderBottom = 0.0f;
    @DoNotStrip
    private int mLayoutDirection = 0;
    @DoNotStrip
    private boolean mHasNewLayout = true;
    @DoNotStrip
    private boolean mDoesLegacyStretchFlagAffectsLayout = false;

    static native int jni_YGNodeGetInstanceCount();

    private native long jni_YGNodeNew();

    public YogaNode() {
        this.mNativePointer = this.jni_YGNodeNew();
        if (this.mNativePointer == 0L) {
            throw new IllegalStateException("Failed to allocate native memory");
        }
    }

    private native long jni_YGNodeNewWithConfig(long var1);

    public YogaNode(YogaConfig config) {
        this.mNativePointer = this.jni_YGNodeNewWithConfig(config.mNativePointer);
        if (this.mNativePointer == 0L) {
            throw new IllegalStateException("Failed to allocate native memory");
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.freeNatives();
        }
        finally {
            super.finalize();
        }
    }

    private static native void jni_YGNodeFree(long var0);

    public void freeNatives() {
        if (this.mNativePointer > 0L) {
            long nativePointer = this.mNativePointer;
            this.mNativePointer = 0L;
            YogaNode.jni_YGNodeFree(nativePointer);
        }
    }

    private static native void jni_YGNodeReset(long var0);

    public void reset() {
        this.mEdgeSetFlag = 0;
        this.mHasSetPosition = false;
        this.mHasNewLayout = true;
        this.mWidth = Float.NaN;
        this.mHeight = Float.NaN;
        this.mTop = Float.NaN;
        this.mLeft = Float.NaN;
        this.mMarginLeft = 0.0f;
        this.mMarginTop = 0.0f;
        this.mMarginRight = 0.0f;
        this.mMarginBottom = 0.0f;
        this.mPaddingLeft = 0.0f;
        this.mPaddingTop = 0.0f;
        this.mPaddingRight = 0.0f;
        this.mPaddingBottom = 0.0f;
        this.mBorderLeft = 0.0f;
        this.mBorderTop = 0.0f;
        this.mBorderRight = 0.0f;
        this.mBorderBottom = 0.0f;
        this.mLayoutDirection = 0;
        this.mMeasureFunction = null;
        this.mBaselineFunction = null;
        this.mData = null;
        this.mDoesLegacyStretchFlagAffectsLayout = false;
        YogaNode.jni_YGNodeReset(this.mNativePointer);
    }

    public int getChildCount() {
        return this.mChildren == null ? 0 : this.mChildren.size();
    }

    public YogaNode getChildAt(int i) {
        if (this.mChildren == null) {
            throw new IllegalStateException("YogaNode does not have children");
        }
        return this.mChildren.get(i);
    }

    private static native void jni_YGNodeInsertChild(long var0, long var2, int var4);

    public void addChildAt(YogaNode child, int i) {
        if (child.mOwner != null) {
            throw new IllegalStateException("Child already has a parent, it must be removed first.");
        }
        if (this.mChildren == null) {
            this.mChildren = new ArrayList<YogaNode>(4);
        }
        this.mChildren.add(i, child);
        child.mOwner = this;
        YogaNode.jni_YGNodeInsertChild(this.mNativePointer, child.mNativePointer, i);
    }

    private static native void jni_YGNodeSetIsReferenceBaseline(long var0, boolean var2);

    public void setIsReferenceBaseline(boolean isReferenceBaseline) {
        YogaNode.jni_YGNodeSetIsReferenceBaseline(this.mNativePointer, isReferenceBaseline);
    }

    private static native boolean jni_YGNodeIsReferenceBaseline(long var0);

    public boolean isReferenceBaseline() {
        return YogaNode.jni_YGNodeIsReferenceBaseline(this.mNativePointer);
    }

    private static native void jni_YGNodeSetOwner(long var0, long var2);

    private native long jni_YGNodeClone(long var1, Object var3);

    public YogaNode clone() {
        try {
            YogaNode clonedYogaNode = (YogaNode)super.clone();
            long clonedNativePointer = this.jni_YGNodeClone(this.mNativePointer, clonedYogaNode);
            if (this.mChildren != null) {
                for (YogaNode child : this.mChildren) {
                    YogaNode.jni_YGNodeSetOwner(child.mNativePointer, 0L);
                    child.mOwner = null;
                }
            }
            clonedYogaNode.mNativePointer = clonedNativePointer;
            clonedYogaNode.mOwner = null;
            List<YogaNode> list = clonedYogaNode.mChildren = this.mChildren != null ? (List<YogaNode>)((ArrayList)this.mChildren).clone() : null;
            if (clonedYogaNode.mChildren != null) {
                for (YogaNode child : clonedYogaNode.mChildren) {
                    child.mOwner = null;
                }
            }
            return clonedYogaNode;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public YogaNode cloneWithNewChildren() {
        try {
            YogaNode clonedYogaNode = (YogaNode)super.clone();
            long clonedNativePointer = this.jni_YGNodeClone(this.mNativePointer, clonedYogaNode);
            clonedYogaNode.mOwner = null;
            clonedYogaNode.mNativePointer = clonedNativePointer;
            clonedYogaNode.clearChildren();
            return clonedYogaNode;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static native void jni_YGNodeClearChildren(long var0);

    private void clearChildren() {
        this.mChildren = null;
        YogaNode.jni_YGNodeClearChildren(this.mNativePointer);
    }

    private static native void jni_YGNodeRemoveChild(long var0, long var2);

    public YogaNode removeChildAt(int i) {
        if (this.mChildren == null) {
            throw new IllegalStateException("Trying to remove a child of a YogaNode that does not have children");
        }
        YogaNode child = this.mChildren.remove(i);
        child.mOwner = null;
        YogaNode.jni_YGNodeRemoveChild(this.mNativePointer, child.mNativePointer);
        return child;
    }

    @Nullable
    public YogaNode getOwner() {
        return this.mOwner;
    }

    @Deprecated
    @Nullable
    public YogaNode getParent() {
        return this.getOwner();
    }

    public int indexOf(YogaNode child) {
        return this.mChildren == null ? -1 : this.mChildren.indexOf(child);
    }

    private static native void jni_YGNodeCalculateLayout(long var0, float var2, float var3);

    public void calculateLayout(float width, float height) {
        YogaNode.jni_YGNodeCalculateLayout(this.mNativePointer, width, height);
    }

    public boolean hasNewLayout() {
        return this.mHasNewLayout;
    }

    private static native void jni_YGNodeMarkDirty(long var0);

    public void dirty() {
        YogaNode.jni_YGNodeMarkDirty(this.mNativePointer);
    }

    private static native void jni_YGNodeMarkDirtyAndPropogateToDescendants(long var0);

    public void dirtyAllDescendants() {
        YogaNode.jni_YGNodeMarkDirtyAndPropogateToDescendants(this.mNativePointer);
    }

    private static native boolean jni_YGNodeIsDirty(long var0);

    public boolean isDirty() {
        return YogaNode.jni_YGNodeIsDirty(this.mNativePointer);
    }

    private static native void jni_YGNodeCopyStyle(long var0, long var2);

    public void copyStyle(YogaNode srcNode) {
        YogaNode.jni_YGNodeCopyStyle(this.mNativePointer, srcNode.mNativePointer);
    }

    public void markLayoutSeen() {
        this.mHasNewLayout = false;
    }

    private static native int jni_YGNodeStyleGetDirection(long var0);

    public YogaDirection getStyleDirection() {
        return YogaDirection.fromInt(YogaNode.jni_YGNodeStyleGetDirection(this.mNativePointer));
    }

    private static native void jni_YGNodeStyleSetDirection(long var0, int var2);

    public void setDirection(YogaDirection direction) {
        YogaNode.jni_YGNodeStyleSetDirection(this.mNativePointer, direction.intValue());
    }

    private static native int jni_YGNodeStyleGetFlexDirection(long var0);

    public YogaFlexDirection getFlexDirection() {
        return YogaFlexDirection.fromInt(YogaNode.jni_YGNodeStyleGetFlexDirection(this.mNativePointer));
    }

    private static native void jni_YGNodeStyleSetFlexDirection(long var0, int var2);

    public void setFlexDirection(YogaFlexDirection flexDirection) {
        YogaNode.jni_YGNodeStyleSetFlexDirection(this.mNativePointer, flexDirection.intValue());
    }

    private static native int jni_YGNodeStyleGetJustifyContent(long var0);

    public YogaJustify getJustifyContent() {
        return YogaJustify.fromInt(YogaNode.jni_YGNodeStyleGetJustifyContent(this.mNativePointer));
    }

    private static native void jni_YGNodeStyleSetJustifyContent(long var0, int var2);

    public void setJustifyContent(YogaJustify justifyContent) {
        YogaNode.jni_YGNodeStyleSetJustifyContent(this.mNativePointer, justifyContent.intValue());
    }

    private static native int jni_YGNodeStyleGetAlignItems(long var0);

    public YogaAlign getAlignItems() {
        return YogaAlign.fromInt(YogaNode.jni_YGNodeStyleGetAlignItems(this.mNativePointer));
    }

    private static native void jni_YGNodeStyleSetAlignItems(long var0, int var2);

    public void setAlignItems(YogaAlign alignItems) {
        YogaNode.jni_YGNodeStyleSetAlignItems(this.mNativePointer, alignItems.intValue());
    }

    private static native int jni_YGNodeStyleGetAlignSelf(long var0);

    public YogaAlign getAlignSelf() {
        return YogaAlign.fromInt(YogaNode.jni_YGNodeStyleGetAlignSelf(this.mNativePointer));
    }

    private static native void jni_YGNodeStyleSetAlignSelf(long var0, int var2);

    public void setAlignSelf(YogaAlign alignSelf) {
        YogaNode.jni_YGNodeStyleSetAlignSelf(this.mNativePointer, alignSelf.intValue());
    }

    private static native int jni_YGNodeStyleGetAlignContent(long var0);

    public YogaAlign getAlignContent() {
        return YogaAlign.fromInt(YogaNode.jni_YGNodeStyleGetAlignContent(this.mNativePointer));
    }

    private static native void jni_YGNodeStyleSetAlignContent(long var0, int var2);

    public void setAlignContent(YogaAlign alignContent) {
        YogaNode.jni_YGNodeStyleSetAlignContent(this.mNativePointer, alignContent.intValue());
    }

    private static native int jni_YGNodeStyleGetPositionType(long var0);

    public YogaPositionType getPositionType() {
        return YogaPositionType.fromInt(YogaNode.jni_YGNodeStyleGetPositionType(this.mNativePointer));
    }

    private static native void jni_YGNodeStyleSetPositionType(long var0, int var2);

    public void setPositionType(YogaPositionType positionType) {
        YogaNode.jni_YGNodeStyleSetPositionType(this.mNativePointer, positionType.intValue());
    }

    private static native void jni_YGNodeStyleSetFlexWrap(long var0, int var2);

    public void setWrap(YogaWrap flexWrap) {
        YogaNode.jni_YGNodeStyleSetFlexWrap(this.mNativePointer, flexWrap.intValue());
    }

    private static native int jni_YGNodeStyleGetOverflow(long var0);

    public YogaOverflow getOverflow() {
        return YogaOverflow.fromInt(YogaNode.jni_YGNodeStyleGetOverflow(this.mNativePointer));
    }

    private static native void jni_YGNodeStyleSetOverflow(long var0, int var2);

    public void setOverflow(YogaOverflow overflow) {
        YogaNode.jni_YGNodeStyleSetOverflow(this.mNativePointer, overflow.intValue());
    }

    private static native int jni_YGNodeStyleGetDisplay(long var0);

    public YogaDisplay getDisplay() {
        return YogaDisplay.fromInt(YogaNode.jni_YGNodeStyleGetDisplay(this.mNativePointer));
    }

    private static native void jni_YGNodeStyleSetDisplay(long var0, int var2);

    public void setDisplay(YogaDisplay display) {
        YogaNode.jni_YGNodeStyleSetDisplay(this.mNativePointer, display.intValue());
    }

    private static native void jni_YGNodeStyleSetFlex(long var0, float var2);

    public void setFlex(float flex) {
        YogaNode.jni_YGNodeStyleSetFlex(this.mNativePointer, flex);
    }

    private static native float jni_YGNodeStyleGetFlexGrow(long var0);

    public float getFlexGrow() {
        return YogaNode.jni_YGNodeStyleGetFlexGrow(this.mNativePointer);
    }

    private static native void jni_YGNodeStyleSetFlexGrow(long var0, float var2);

    public void setFlexGrow(float flexGrow) {
        YogaNode.jni_YGNodeStyleSetFlexGrow(this.mNativePointer, flexGrow);
    }

    private static native float jni_YGNodeStyleGetFlexShrink(long var0);

    public float getFlexShrink() {
        return YogaNode.jni_YGNodeStyleGetFlexShrink(this.mNativePointer);
    }

    private static native void jni_YGNodeStyleSetFlexShrink(long var0, float var2);

    public void setFlexShrink(float flexShrink) {
        YogaNode.jni_YGNodeStyleSetFlexShrink(this.mNativePointer, flexShrink);
    }

    private static native Object jni_YGNodeStyleGetFlexBasis(long var0);

    public YogaValue getFlexBasis() {
        return (YogaValue)YogaNode.jni_YGNodeStyleGetFlexBasis(this.mNativePointer);
    }

    private static native void jni_YGNodeStyleSetFlexBasis(long var0, float var2);

    public void setFlexBasis(float flexBasis) {
        YogaNode.jni_YGNodeStyleSetFlexBasis(this.mNativePointer, flexBasis);
    }

    private static native void jni_YGNodeStyleSetFlexBasisPercent(long var0, float var2);

    public void setFlexBasisPercent(float percent) {
        YogaNode.jni_YGNodeStyleSetFlexBasisPercent(this.mNativePointer, percent);
    }

    private static native void jni_YGNodeStyleSetFlexBasisAuto(long var0);

    public void setFlexBasisAuto() {
        YogaNode.jni_YGNodeStyleSetFlexBasisAuto(this.mNativePointer);
    }

    private static native Object jni_YGNodeStyleGetMargin(long var0, int var2);

    public YogaValue getMargin(YogaEdge edge) {
        if ((this.mEdgeSetFlag & 1) != 1) {
            return YogaValue.UNDEFINED;
        }
        return (YogaValue)YogaNode.jni_YGNodeStyleGetMargin(this.mNativePointer, edge.intValue());
    }

    private static native void jni_YGNodeStyleSetMargin(long var0, int var2, float var3);

    public void setMargin(YogaEdge edge, float margin) {
        this.mEdgeSetFlag |= 1;
        YogaNode.jni_YGNodeStyleSetMargin(this.mNativePointer, edge.intValue(), margin);
    }

    private static native void jni_YGNodeStyleSetMarginPercent(long var0, int var2, float var3);

    public void setMarginPercent(YogaEdge edge, float percent) {
        this.mEdgeSetFlag |= 1;
        YogaNode.jni_YGNodeStyleSetMarginPercent(this.mNativePointer, edge.intValue(), percent);
    }

    private static native void jni_YGNodeStyleSetMarginAuto(long var0, int var2);

    public void setMarginAuto(YogaEdge edge) {
        this.mEdgeSetFlag |= 1;
        YogaNode.jni_YGNodeStyleSetMarginAuto(this.mNativePointer, edge.intValue());
    }

    private static native Object jni_YGNodeStyleGetPadding(long var0, int var2);

    public YogaValue getPadding(YogaEdge edge) {
        if ((this.mEdgeSetFlag & 2) != 2) {
            return YogaValue.UNDEFINED;
        }
        return (YogaValue)YogaNode.jni_YGNodeStyleGetPadding(this.mNativePointer, edge.intValue());
    }

    private static native void jni_YGNodeStyleSetPadding(long var0, int var2, float var3);

    public void setPadding(YogaEdge edge, float padding) {
        this.mEdgeSetFlag |= 2;
        YogaNode.jni_YGNodeStyleSetPadding(this.mNativePointer, edge.intValue(), padding);
    }

    private static native void jni_YGNodeStyleSetPaddingPercent(long var0, int var2, float var3);

    public void setPaddingPercent(YogaEdge edge, float percent) {
        this.mEdgeSetFlag |= 2;
        YogaNode.jni_YGNodeStyleSetPaddingPercent(this.mNativePointer, edge.intValue(), percent);
    }

    private static native float jni_YGNodeStyleGetBorder(long var0, int var2);

    public float getBorder(YogaEdge edge) {
        if ((this.mEdgeSetFlag & 4) != 4) {
            return Float.NaN;
        }
        return YogaNode.jni_YGNodeStyleGetBorder(this.mNativePointer, edge.intValue());
    }

    private static native void jni_YGNodeStyleSetBorder(long var0, int var2, float var3);

    public void setBorder(YogaEdge edge, float border) {
        this.mEdgeSetFlag |= 4;
        YogaNode.jni_YGNodeStyleSetBorder(this.mNativePointer, edge.intValue(), border);
    }

    private static native Object jni_YGNodeStyleGetPosition(long var0, int var2);

    public YogaValue getPosition(YogaEdge edge) {
        if (!this.mHasSetPosition) {
            return YogaValue.UNDEFINED;
        }
        return (YogaValue)YogaNode.jni_YGNodeStyleGetPosition(this.mNativePointer, edge.intValue());
    }

    private static native void jni_YGNodeStyleSetPosition(long var0, int var2, float var3);

    public void setPosition(YogaEdge edge, float position) {
        this.mHasSetPosition = true;
        YogaNode.jni_YGNodeStyleSetPosition(this.mNativePointer, edge.intValue(), position);
    }

    private static native void jni_YGNodeStyleSetPositionPercent(long var0, int var2, float var3);

    public void setPositionPercent(YogaEdge edge, float percent) {
        this.mHasSetPosition = true;
        YogaNode.jni_YGNodeStyleSetPositionPercent(this.mNativePointer, edge.intValue(), percent);
    }

    private static native Object jni_YGNodeStyleGetWidth(long var0);

    public YogaValue getWidth() {
        return (YogaValue)YogaNode.jni_YGNodeStyleGetWidth(this.mNativePointer);
    }

    private static native void jni_YGNodeStyleSetWidth(long var0, float var2);

    public void setWidth(float width) {
        YogaNode.jni_YGNodeStyleSetWidth(this.mNativePointer, width);
    }

    private static native void jni_YGNodeStyleSetWidthPercent(long var0, float var2);

    public void setWidthPercent(float percent) {
        YogaNode.jni_YGNodeStyleSetWidthPercent(this.mNativePointer, percent);
    }

    private static native void jni_YGNodeStyleSetWidthAuto(long var0);

    public void setWidthAuto() {
        YogaNode.jni_YGNodeStyleSetWidthAuto(this.mNativePointer);
    }

    private static native Object jni_YGNodeStyleGetHeight(long var0);

    public YogaValue getHeight() {
        return (YogaValue)YogaNode.jni_YGNodeStyleGetHeight(this.mNativePointer);
    }

    private static native void jni_YGNodeStyleSetHeight(long var0, float var2);

    public void setHeight(float height) {
        YogaNode.jni_YGNodeStyleSetHeight(this.mNativePointer, height);
    }

    private static native void jni_YGNodeStyleSetHeightPercent(long var0, float var2);

    public void setHeightPercent(float percent) {
        YogaNode.jni_YGNodeStyleSetHeightPercent(this.mNativePointer, percent);
    }

    private static native void jni_YGNodeStyleSetHeightAuto(long var0);

    public void setHeightAuto() {
        YogaNode.jni_YGNodeStyleSetHeightAuto(this.mNativePointer);
    }

    private static native Object jni_YGNodeStyleGetMinWidth(long var0);

    public YogaValue getMinWidth() {
        return (YogaValue)YogaNode.jni_YGNodeStyleGetMinWidth(this.mNativePointer);
    }

    private static native void jni_YGNodeStyleSetMinWidth(long var0, float var2);

    public void setMinWidth(float minWidth) {
        YogaNode.jni_YGNodeStyleSetMinWidth(this.mNativePointer, minWidth);
    }

    private static native void jni_YGNodeStyleSetMinWidthPercent(long var0, float var2);

    public void setMinWidthPercent(float percent) {
        YogaNode.jni_YGNodeStyleSetMinWidthPercent(this.mNativePointer, percent);
    }

    private static native Object jni_YGNodeStyleGetMinHeight(long var0);

    public YogaValue getMinHeight() {
        return (YogaValue)YogaNode.jni_YGNodeStyleGetMinHeight(this.mNativePointer);
    }

    private static native void jni_YGNodeStyleSetMinHeight(long var0, float var2);

    public void setMinHeight(float minHeight) {
        YogaNode.jni_YGNodeStyleSetMinHeight(this.mNativePointer, minHeight);
    }

    private static native void jni_YGNodeStyleSetMinHeightPercent(long var0, float var2);

    public void setMinHeightPercent(float percent) {
        YogaNode.jni_YGNodeStyleSetMinHeightPercent(this.mNativePointer, percent);
    }

    private static native Object jni_YGNodeStyleGetMaxWidth(long var0);

    public YogaValue getMaxWidth() {
        return (YogaValue)YogaNode.jni_YGNodeStyleGetMaxWidth(this.mNativePointer);
    }

    private static native void jni_YGNodeStyleSetMaxWidth(long var0, float var2);

    public void setMaxWidth(float maxWidth) {
        YogaNode.jni_YGNodeStyleSetMaxWidth(this.mNativePointer, maxWidth);
    }

    private static native void jni_YGNodeStyleSetMaxWidthPercent(long var0, float var2);

    public void setMaxWidthPercent(float percent) {
        YogaNode.jni_YGNodeStyleSetMaxWidthPercent(this.mNativePointer, percent);
    }

    private static native Object jni_YGNodeStyleGetMaxHeight(long var0);

    public YogaValue getMaxHeight() {
        return (YogaValue)YogaNode.jni_YGNodeStyleGetMaxHeight(this.mNativePointer);
    }

    private static native void jni_YGNodeStyleSetMaxHeight(long var0, float var2);

    public void setMaxHeight(float maxheight) {
        YogaNode.jni_YGNodeStyleSetMaxHeight(this.mNativePointer, maxheight);
    }

    private static native void jni_YGNodeStyleSetMaxHeightPercent(long var0, float var2);

    public void setMaxHeightPercent(float percent) {
        YogaNode.jni_YGNodeStyleSetMaxHeightPercent(this.mNativePointer, percent);
    }

    private static native float jni_YGNodeStyleGetAspectRatio(long var0);

    public float getAspectRatio() {
        return YogaNode.jni_YGNodeStyleGetAspectRatio(this.mNativePointer);
    }

    private static native void jni_YGNodeStyleSetAspectRatio(long var0, float var2);

    public void setAspectRatio(float aspectRatio) {
        YogaNode.jni_YGNodeStyleSetAspectRatio(this.mNativePointer, aspectRatio);
    }

    public float getLayoutX() {
        return this.mLeft;
    }

    public float getLayoutY() {
        return this.mTop;
    }

    public float getLayoutWidth() {
        return this.mWidth;
    }

    public float getLayoutHeight() {
        return this.mHeight;
    }

    public boolean getDoesLegacyStretchFlagAffectsLayout() {
        return this.mDoesLegacyStretchFlagAffectsLayout;
    }

    public float getLayoutMargin(YogaEdge edge) {
        switch (edge) {
            case LEFT: {
                return this.mMarginLeft;
            }
            case TOP: {
                return this.mMarginTop;
            }
            case RIGHT: {
                return this.mMarginRight;
            }
            case BOTTOM: {
                return this.mMarginBottom;
            }
            case START: {
                return this.getLayoutDirection() == YogaDirection.RTL ? this.mMarginRight : this.mMarginLeft;
            }
            case END: {
                return this.getLayoutDirection() == YogaDirection.RTL ? this.mMarginLeft : this.mMarginRight;
            }
        }
        throw new IllegalArgumentException("Cannot get layout margins of multi-edge shorthands");
    }

    public float getLayoutPadding(YogaEdge edge) {
        switch (edge) {
            case LEFT: {
                return this.mPaddingLeft;
            }
            case TOP: {
                return this.mPaddingTop;
            }
            case RIGHT: {
                return this.mPaddingRight;
            }
            case BOTTOM: {
                return this.mPaddingBottom;
            }
            case START: {
                return this.getLayoutDirection() == YogaDirection.RTL ? this.mPaddingRight : this.mPaddingLeft;
            }
            case END: {
                return this.getLayoutDirection() == YogaDirection.RTL ? this.mPaddingLeft : this.mPaddingRight;
            }
        }
        throw new IllegalArgumentException("Cannot get layout paddings of multi-edge shorthands");
    }

    public float getLayoutBorder(YogaEdge edge) {
        switch (edge) {
            case LEFT: {
                return this.mBorderLeft;
            }
            case TOP: {
                return this.mBorderTop;
            }
            case RIGHT: {
                return this.mBorderRight;
            }
            case BOTTOM: {
                return this.mBorderBottom;
            }
            case START: {
                return this.getLayoutDirection() == YogaDirection.RTL ? this.mBorderRight : this.mBorderLeft;
            }
            case END: {
                return this.getLayoutDirection() == YogaDirection.RTL ? this.mBorderLeft : this.mBorderRight;
            }
        }
        throw new IllegalArgumentException("Cannot get layout border of multi-edge shorthands");
    }

    public YogaDirection getLayoutDirection() {
        return YogaDirection.fromInt(this.mLayoutDirection);
    }

    private static native void jni_YGNodeSetHasMeasureFunc(long var0, boolean var2);

    public void setMeasureFunction(YogaMeasureFunction measureFunction) {
        this.mMeasureFunction = measureFunction;
        YogaNode.jni_YGNodeSetHasMeasureFunc(this.mNativePointer, measureFunction != null);
    }

    @DoNotStrip
    public final long measure(float width, int widthMode, float height, int heightMode) {
        if (!this.isMeasureDefined()) {
            throw new RuntimeException("Measure function isn't defined!");
        }
        return this.mMeasureFunction.measure(this, width, YogaMeasureMode.fromInt(widthMode), height, YogaMeasureMode.fromInt(heightMode));
    }

    private static native void jni_YGNodeSetHasBaselineFunc(long var0, boolean var2);

    public void setBaselineFunction(YogaBaselineFunction baselineFunction) {
        this.mBaselineFunction = baselineFunction;
        YogaNode.jni_YGNodeSetHasBaselineFunc(this.mNativePointer, baselineFunction != null);
    }

    @DoNotStrip
    public final float baseline(float width, float height) {
        return this.mBaselineFunction.baseline(this, width, height);
    }

    public boolean isMeasureDefined() {
        return this.mMeasureFunction != null;
    }

    public void setData(Object data) {
        this.mData = data;
    }

    public Object getData() {
        return this.mData;
    }

    private static native void jni_YGNodePrint(long var0);

    public void print() {
        YogaNode.jni_YGNodePrint(this.mNativePointer);
    }

    @DoNotStrip
    private final long replaceChild(YogaNode newNode, int childIndex) {
        if (this.mChildren == null) {
            throw new IllegalStateException("Cannot replace child. YogaNode does not have children");
        }
        this.mChildren.remove(childIndex);
        this.mChildren.add(childIndex, newNode);
        newNode.mOwner = this;
        return newNode.mNativePointer;
    }

    static {
        SoLoader.loadLibrary((String)"yoga");
    }
}

