/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.Context;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.text.SpannableString;
import android.text.style.URLSpan;
import android.view.View;
import com.facebook.react.R;
import java.util.Locale;
import javax.annotation.Nullable;

public class AccessibilityDelegateUtil {
    private AccessibilityDelegateUtil() {
    }

    public static void setDelegate(final View view) {
        final String accessibilityHint = (String)view.getTag(R.id.accessibility_hint);
        final AccessibilityRole accessibilityRole = (AccessibilityRole)((Object)view.getTag(R.id.accessibility_role));
        if (!(ViewCompat.hasAccessibilityDelegate((View)view) || accessibilityHint == null && accessibilityRole == null)) {
            ViewCompat.setAccessibilityDelegate((View)view, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

                public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
                    super.onInitializeAccessibilityNodeInfo(host, info);
                    if (accessibilityHint != null) {
                        String contentDescription = (String)info.getContentDescription();
                        if (contentDescription != null) {
                            contentDescription = contentDescription + ", " + accessibilityHint;
                            info.setContentDescription((CharSequence)contentDescription);
                        } else {
                            info.setContentDescription((CharSequence)accessibilityHint);
                        }
                    }
                    AccessibilityDelegateUtil.setRole(info, accessibilityRole, view.getContext());
                }
            });
        }
    }

    public static void setRole(AccessibilityNodeInfoCompat nodeInfo, AccessibilityRole role, Context context) {
        if (role == null) {
            role = AccessibilityRole.NONE;
        }
        nodeInfo.setClassName((CharSequence)AccessibilityRole.getValue(role));
        if (Locale.getDefault().getLanguage().equals(new Locale("en").getLanguage())) {
            if (role.equals((Object)AccessibilityRole.LINK)) {
                SpannableString spannable;
                nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.link_description));
                if (nodeInfo.getContentDescription() != null) {
                    spannable = new SpannableString(nodeInfo.getContentDescription());
                    spannable.setSpan((Object)new URLSpan(""), 0, spannable.length(), 0);
                    nodeInfo.setContentDescription((CharSequence)spannable);
                }
                if (nodeInfo.getText() != null) {
                    spannable = new SpannableString(nodeInfo.getText());
                    spannable.setSpan((Object)new URLSpan(""), 0, spannable.length(), 0);
                    nodeInfo.setText((CharSequence)spannable);
                }
            }
            if (role.equals((Object)AccessibilityRole.SEARCH)) {
                nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.search_description));
            }
            if (role.equals((Object)AccessibilityRole.IMAGE)) {
                nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.image_description));
            }
            if (role.equals((Object)AccessibilityRole.IMAGEBUTTON)) {
                nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.image_button_description));
            }
            if (role.equals((Object)AccessibilityRole.ADJUSTABLE)) {
                nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.adjustable_description));
            }
            if (role.equals((Object)AccessibilityRole.HEADER)) {
                nodeInfo.setRoleDescription((CharSequence)context.getString(R.string.header_description));
                AccessibilityNodeInfoCompat.CollectionItemInfoCompat itemInfo = AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)0, (int)1, (int)0, (int)1, (boolean)true);
                nodeInfo.setCollectionItemInfo((Object)itemInfo);
            }
        }
        if (role.equals((Object)AccessibilityRole.IMAGEBUTTON)) {
            nodeInfo.setClickable(true);
        }
    }

    public static enum AccessibilityRole {
        NONE,
        BUTTON,
        LINK,
        SEARCH,
        IMAGE,
        IMAGEBUTTON,
        KEYBOARDKEY,
        TEXT,
        ADJUSTABLE,
        SUMMARY,
        HEADER;


        public static String getValue(AccessibilityRole role) {
            switch (role) {
                case NONE: {
                    return null;
                }
                case BUTTON: {
                    return "android.widget.Button";
                }
                case LINK: {
                    return "android.widget.ViewGroup";
                }
                case SEARCH: {
                    return "android.widget.EditText";
                }
                case IMAGE: {
                    return "android.widget.ImageView";
                }
                case IMAGEBUTTON: {
                    return "android.widget.ImageView";
                }
                case KEYBOARDKEY: {
                    return "android.inputmethodservice.Keyboard$Key";
                }
                case TEXT: {
                    return "android.widget.ViewGroup";
                }
                case ADJUSTABLE: {
                    return "android.widget.SeekBar";
                }
                case SUMMARY: {
                    return "android.widget.ViewGroup";
                }
                case HEADER: {
                    return "android.widget.ViewGroup";
                }
            }
            throw new IllegalArgumentException("Invalid accessibility role value: " + (Object)((Object)role));
        }

        public static AccessibilityRole fromValue(@Nullable String value) {
            for (AccessibilityRole role : AccessibilityRole.values()) {
                if (!role.name().equalsIgnoreCase(value)) continue;
                return role;
            }
            throw new IllegalArgumentException("Invalid accessibility role value: " + value);
        }
    }
}

