/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.layoutanimation;

import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.uimanager.layoutanimation.AbstractLayoutAnimation;
import com.facebook.react.uimanager.layoutanimation.LayoutAnimationListener;
import com.facebook.react.uimanager.layoutanimation.LayoutAnimationType;
import com.facebook.react.uimanager.layoutanimation.LayoutCreateAnimation;
import com.facebook.react.uimanager.layoutanimation.LayoutDeleteAnimation;
import com.facebook.react.uimanager.layoutanimation.LayoutHandlingAnimation;
import com.facebook.react.uimanager.layoutanimation.LayoutUpdateAnimation;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class LayoutAnimationController {
    private static final boolean ENABLED = true;
    private final AbstractLayoutAnimation mLayoutCreateAnimation = new LayoutCreateAnimation();
    private final AbstractLayoutAnimation mLayoutUpdateAnimation = new LayoutUpdateAnimation();
    private final AbstractLayoutAnimation mLayoutDeleteAnimation = new LayoutDeleteAnimation();
    private final SparseArray<LayoutHandlingAnimation> mLayoutHandlers = new SparseArray(0);
    private boolean mShouldAnimateLayout;

    public void initializeFromConfig(@Nullable ReadableMap config) {
        int globalDuration;
        if (config == null) {
            this.reset();
            return;
        }
        this.mShouldAnimateLayout = false;
        int n = globalDuration = config.hasKey("duration") ? config.getInt("duration") : 0;
        if (config.hasKey(LayoutAnimationType.toString(LayoutAnimationType.CREATE))) {
            this.mLayoutCreateAnimation.initializeFromConfig(config.getMap(LayoutAnimationType.toString(LayoutAnimationType.CREATE)), globalDuration);
            this.mShouldAnimateLayout = true;
        }
        if (config.hasKey(LayoutAnimationType.toString(LayoutAnimationType.UPDATE))) {
            this.mLayoutUpdateAnimation.initializeFromConfig(config.getMap(LayoutAnimationType.toString(LayoutAnimationType.UPDATE)), globalDuration);
            this.mShouldAnimateLayout = true;
        }
        if (config.hasKey(LayoutAnimationType.toString(LayoutAnimationType.DELETE))) {
            this.mLayoutDeleteAnimation.initializeFromConfig(config.getMap(LayoutAnimationType.toString(LayoutAnimationType.DELETE)), globalDuration);
            this.mShouldAnimateLayout = true;
        }
    }

    public void reset() {
        this.mLayoutCreateAnimation.reset();
        this.mLayoutUpdateAnimation.reset();
        this.mLayoutDeleteAnimation.reset();
        this.mShouldAnimateLayout = false;
    }

    public boolean shouldAnimateLayout(View viewToAnimate) {
        return this.mShouldAnimateLayout && viewToAnimate.getParent() != null || this.mLayoutHandlers.get(viewToAnimate.getId()) != null;
    }

    public void applyLayoutUpdate(View view, int x, int y, int width, int height) {
        UiThreadUtil.assertOnUiThread();
        final int reactTag = view.getId();
        LayoutHandlingAnimation existingAnimation = (LayoutHandlingAnimation)this.mLayoutHandlers.get(reactTag);
        if (existingAnimation != null) {
            existingAnimation.onLayoutUpdate(x, y, width, height);
            return;
        }
        AbstractLayoutAnimation layoutAnimation = view.getWidth() == 0 || view.getHeight() == 0 ? this.mLayoutCreateAnimation : this.mLayoutUpdateAnimation;
        Animation animation = layoutAnimation.createAnimation(view, x, y, width, height);
        if (animation instanceof LayoutHandlingAnimation) {
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    LayoutAnimationController.this.mLayoutHandlers.put(reactTag, (Object)((LayoutHandlingAnimation)animation));
                }

                public void onAnimationEnd(Animation animation) {
                    LayoutAnimationController.this.mLayoutHandlers.remove(reactTag);
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
        } else {
            view.layout(x, y, x + width, y + height);
        }
        if (animation != null) {
            view.startAnimation(animation);
        }
    }

    public void deleteView(View view, final LayoutAnimationListener listener) {
        UiThreadUtil.assertOnUiThread();
        AbstractLayoutAnimation layoutAnimation = this.mLayoutDeleteAnimation;
        Animation animation = layoutAnimation.createAnimation(view, view.getLeft(), view.getTop(), view.getWidth(), view.getHeight());
        if (animation != null) {
            this.disableUserInteractions(view);
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation anim) {
                }

                public void onAnimationRepeat(Animation anim) {
                }

                public void onAnimationEnd(Animation anim) {
                    listener.onAnimationEnd();
                }
            });
            view.startAnimation(animation);
        } else {
            listener.onAnimationEnd();
        }
    }

    private void disableUserInteractions(View view) {
        view.setClickable(false);
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                this.disableUserInteractions(viewGroup.getChildAt(i));
            }
        }
    }
}

