/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting;

import android.view.View;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.yoga.YogaMeasureMode;

public class LayoutMetricsConversions {
    public static final int REACT_CONSTRAINT_UNDEFINED = Integer.MIN_VALUE;

    public static float getMinSize(int viewMeasureSpec) {
        int mode = View.MeasureSpec.getMode((int)viewMeasureSpec);
        int size = View.MeasureSpec.getSize((int)viewMeasureSpec);
        return mode == 0x40000000 ? (float)size : 0.0f;
    }

    public static float getMaxSize(int viewMeasureSpec) {
        int mode = View.MeasureSpec.getMode((int)viewMeasureSpec);
        int size = View.MeasureSpec.getSize((int)viewMeasureSpec);
        return mode == 0 ? -2.1474836E9f : (float)size;
    }

    public static float getYogaSize(float minSize, float maxSize) {
        float yogaSize = minSize == maxSize ? PixelUtil.toPixelFromDIP(maxSize) : (maxSize == -2.1474836E9f ? 0.0f : PixelUtil.toPixelFromDIP(maxSize));
        return yogaSize;
    }

    public static YogaMeasureMode getYogaMeasureMode(float minSize, float maxSize) {
        YogaMeasureMode yogaMeasureMode = minSize == maxSize ? YogaMeasureMode.EXACTLY : (maxSize == -2.1474836E9f ? YogaMeasureMode.UNDEFINED : YogaMeasureMode.AT_MOST);
        return yogaMeasureMode;
    }
}

