/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class ViewManagerRegistry {
    private final Map<String, ViewManager> mViewManagers;
    @Nullable
    private final UIManagerModule.ViewManagerResolver mViewManagerResolver;

    public ViewManagerRegistry(UIManagerModule.ViewManagerResolver viewManagerResolver) {
        this.mViewManagers = MapBuilder.newHashMap();
        this.mViewManagerResolver = viewManagerResolver;
    }

    public ViewManagerRegistry(List<ViewManager> viewManagerList) {
        HashMap<String, ViewManager> viewManagerMap = MapBuilder.newHashMap();
        for (ViewManager viewManager : viewManagerList) {
            viewManagerMap.put(viewManager.getName(), viewManager);
        }
        this.mViewManagers = viewManagerMap;
        this.mViewManagerResolver = null;
    }

    public void clearResource() {
        if (this.mViewManagers != null) {
            this.mViewManagers.clear();
        }
    }

    public ViewManagerRegistry(Map<String, ViewManager> viewManagerMap) {
        this.mViewManagers = viewManagerMap != null ? viewManagerMap : MapBuilder.newHashMap();
        this.mViewManagerResolver = null;
    }

    public ViewManager get(String className) {
        ViewManager viewManager = this.mViewManagers.get(className);
        if (viewManager != null) {
            return viewManager;
        }
        if (this.mViewManagerResolver != null && (viewManager = this.mViewManagerResolver.getViewManager(className)) != null) {
            this.mViewManagers.put(className, viewManager);
            return viewManager;
        }
        return null;
    }
}

