/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.module.annotations.ReactModule;
import java.io.File;
import javax.annotation.Nullable;

@ReactModule(name="JSCHeapCapture", needsEagerInit=true)
public class JSCHeapCapture
extends ReactContextBaseJavaModule {
    @Nullable
    private CaptureCallback mCaptureInProgress = null;

    public JSCHeapCapture(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    public synchronized void captureHeap(String path, CaptureCallback callback) {
        if (this.mCaptureInProgress != null) {
            callback.onFailure(new CaptureException("Heap capture already in progress."));
            return;
        }
        File f = new File(path + "/capture.json");
        f.delete();
        HeapCapture heapCapture = this.getReactApplicationContext().getJSModule(HeapCapture.class);
        if (heapCapture == null) {
            callback.onFailure(new CaptureException("Heap capture js module not registered."));
            return;
        }
        this.mCaptureInProgress = callback;
        heapCapture.captureHeap(f.getPath());
    }

    @ReactMethod
    public synchronized void captureComplete(String path, String error) {
        if (this.mCaptureInProgress != null) {
            if (error == null) {
                this.mCaptureInProgress.onSuccess(new File(path));
            } else {
                this.mCaptureInProgress.onFailure(new CaptureException(error));
            }
            this.mCaptureInProgress = null;
        }
    }

    @Override
    public String getName() {
        return "JSCHeapCapture";
    }

    public static interface CaptureCallback {
        public void onSuccess(File var1);

        public void onFailure(CaptureException var1);
    }

    public static class CaptureException
    extends Exception {
        CaptureException(String message) {
            super(message);
        }

        CaptureException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface HeapCapture
    extends JavaScriptModule {
        public void captureHeap(String var1);
    }
}

