/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Button;
import android.widget.RadioButton;

class AccessibilityHelper {
    private static final String BUTTON = "button";
    private static final String RADIOBUTTON_CHECKED = "radiobutton_checked";
    private static final String RADIOBUTTON_UNCHECKED = "radiobutton_unchecked";
    private static final View.AccessibilityDelegate BUTTON_DELEGATE = new View.AccessibilityDelegate(){

        public void onInitializeAccessibilityEvent(View host, AccessibilityEvent event) {
            super.onInitializeAccessibilityEvent(host, event);
            event.setClassName((CharSequence)Button.class.getName());
        }

        public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfo info) {
            super.onInitializeAccessibilityNodeInfo(host, info);
            info.setClassName((CharSequence)Button.class.getName());
        }
    };
    private static final View.AccessibilityDelegate RADIOBUTTON_CHECKED_DELEGATE = new View.AccessibilityDelegate(){

        public void onInitializeAccessibilityEvent(View host, AccessibilityEvent event) {
            super.onInitializeAccessibilityEvent(host, event);
            event.setClassName((CharSequence)RadioButton.class.getName());
            event.setChecked(true);
        }

        public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfo info) {
            super.onInitializeAccessibilityNodeInfo(host, info);
            info.setClassName((CharSequence)RadioButton.class.getName());
            info.setCheckable(true);
            info.setChecked(true);
        }
    };
    private static final View.AccessibilityDelegate RADIOBUTTON_UNCHECKED_DELEGATE = new View.AccessibilityDelegate(){

        public void onInitializeAccessibilityEvent(View host, AccessibilityEvent event) {
            super.onInitializeAccessibilityEvent(host, event);
            event.setClassName((CharSequence)RadioButton.class.getName());
            event.setChecked(false);
        }

        public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfo info) {
            super.onInitializeAccessibilityNodeInfo(host, info);
            info.setClassName((CharSequence)RadioButton.class.getName());
            info.setCheckable(true);
            info.setChecked(false);
        }
    };

    AccessibilityHelper() {
    }

    public static void updateAccessibilityComponentType(View view, String componentType) {
        if (componentType == null) {
            view.setAccessibilityDelegate(null);
            return;
        }
        switch (componentType) {
            case "button": {
                view.setAccessibilityDelegate(BUTTON_DELEGATE);
                break;
            }
            case "radiobutton_checked": {
                view.setAccessibilityDelegate(RADIOBUTTON_CHECKED_DELEGATE);
                break;
            }
            case "radiobutton_unchecked": {
                view.setAccessibilityDelegate(RADIOBUTTON_UNCHECKED_DELEGATE);
                break;
            }
            default: {
                view.setAccessibilityDelegate(null);
            }
        }
    }

    public static void sendAccessibilityEvent(View view, int eventType) {
        view.sendAccessibilityEvent(eventType);
    }
}

