/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting.mountitems;

import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.fabric.mounting.MountingManager;
import com.facebook.react.fabric.mounting.mountitems.MountItem;
import com.facebook.systrace.Systrace;

@DoNotStrip
public class BatchMountItem
implements MountItem {
    private final MountItem[] mMountItems;
    private final int mSize;

    public BatchMountItem(MountItem[] items, int size) {
        if (items == null) {
            throw new NullPointerException();
        }
        if (size < 0 || size > items.length) {
            throw new IllegalArgumentException("Invalid size received by parameter size: " + size + " items.size = " + items.length);
        }
        this.mMountItems = items;
        this.mSize = size;
    }

    @Override
    public void execute(MountingManager mountingManager) {
        Systrace.beginSection(0L, "FabricUIManager::mountViews (" + this.mSize + " items)");
        for (int mountItemIndex = 0; mountItemIndex < this.mSize; ++mountItemIndex) {
            MountItem mountItem = this.mMountItems[mountItemIndex];
            mountItem.execute(mountingManager);
        }
        Systrace.endSection(0L);
    }
}

