/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.fresco;

import android.content.Context;
import android.support.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.backends.okhttp3.OkHttpImagePipelineConfigFactory;
import com.facebook.imagepipeline.core.ImagePipelineConfig;
import com.facebook.imagepipeline.producers.NetworkFetcher;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.common.ModuleDataCleaner;
import com.facebook.react.modules.fresco.ReactOkHttpNetworkFetcher;
import com.facebook.react.modules.fresco.SystraceRequestListener;
import com.facebook.react.modules.network.CookieJarContainer;
import com.facebook.react.modules.network.ForwardingCookieHandler;
import com.facebook.react.modules.network.OkHttpClientProvider;
import java.net.CookieHandler;
import java.util.HashSet;
import okhttp3.CookieJar;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;

@ReactModule(name="FrescoModule", needsEagerInit=true)
public class FrescoModule
extends ReactContextBaseJavaModule
implements ModuleDataCleaner.Cleanable,
LifecycleEventListener {
    public static final String NAME = "FrescoModule";
    private final boolean mClearOnDestroy;
    @Nullable
    private static ImagePipelineConfig mConfig;
    private static boolean sHasBeenInitialized;

    public FrescoModule(ReactApplicationContext reactContext) {
        this(reactContext, true, null);
    }

    public FrescoModule(ReactApplicationContext reactContext, boolean clearOnDestroy) {
        this(reactContext, clearOnDestroy, null);
    }

    public FrescoModule(ReactApplicationContext reactContext, boolean clearOnDestroy, @Nullable ImagePipelineConfig config) {
        super(reactContext);
        this.mClearOnDestroy = clearOnDestroy;
        mConfig = config;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.getReactApplicationContext().addLifecycleEventListener(this);
        if (!FrescoModule.hasBeenInitialized()) {
            FrescoModule.initFresco(this.getReactApplicationContext().getApplicationContext());
        } else if (mConfig != null) {
            FLog.w((String)"ReactNative", (String)"Fresco has already been initialized with a different config. The new Fresco configuration will be ignored!");
        }
        mConfig = null;
    }

    public static void initFresco(Context context) {
        if (context == null) {
            return;
        }
        if (!FrescoModule.hasBeenInitialized()) {
            if (mConfig == null) {
                mConfig = FrescoModule.getDefaultConfig(context);
            }
            Fresco.initialize((Context)context, (ImagePipelineConfig)mConfig);
            sHasBeenInitialized = true;
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void clearSensitiveData() {
        Fresco.getImagePipeline().clearCaches();
    }

    public static boolean hasBeenInitialized() {
        return sHasBeenInitialized;
    }

    private static ImagePipelineConfig getDefaultConfig(Context context) {
        return FrescoModule.getDefaultConfigBuilder(context).build();
    }

    public static ImagePipelineConfig.Builder getDefaultConfigBuilder(Context context) {
        HashSet<SystraceRequestListener> requestListeners = new HashSet<SystraceRequestListener>();
        requestListeners.add(new SystraceRequestListener());
        OkHttpClient client = OkHttpClientProvider.createClient();
        CookieJarContainer container = (CookieJarContainer)client.cookieJar();
        ForwardingCookieHandler handler = new ForwardingCookieHandler(context.getApplicationContext());
        container.setCookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)handler));
        return OkHttpImagePipelineConfigFactory.newBuilder((Context)context.getApplicationContext(), (OkHttpClient)client).setNetworkFetcher((NetworkFetcher)new ReactOkHttpNetworkFetcher(client)).setDownsampleEnabled(false).setRequestListeners(requestListeners);
    }

    @Override
    public void onHostResume() {
    }

    @Override
    public void onHostPause() {
    }

    @Override
    public void onHostDestroy() {
        if (FrescoModule.hasBeenInitialized() && this.mClearOnDestroy) {
            Fresco.getImagePipeline().clearMemoryCaches();
        }
    }

    static {
        sHasBeenInitialized = false;
    }
}

