/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.layoutanimation;

import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.facebook.react.uimanager.layoutanimation.LayoutHandlingAnimation;

class PositionAndSizeAnimation
extends Animation
implements LayoutHandlingAnimation {
    private final View mView;
    private float mStartX;
    private float mStartY;
    private float mDeltaX;
    private float mDeltaY;
    private int mStartWidth;
    private int mStartHeight;
    private int mDeltaWidth;
    private int mDeltaHeight;

    public PositionAndSizeAnimation(View view, int x, int y, int width, int height) {
        this.mView = view;
        this.calculateAnimation(x, y, width, height);
    }

    protected void applyTransformation(float interpolatedTime, Transformation t) {
        float newX = this.mStartX + this.mDeltaX * interpolatedTime;
        float newY = this.mStartY + this.mDeltaY * interpolatedTime;
        float newWidth = (float)this.mStartWidth + (float)this.mDeltaWidth * interpolatedTime;
        float newHeight = (float)this.mStartHeight + (float)this.mDeltaHeight * interpolatedTime;
        this.mView.layout(Math.round(newX), Math.round(newY), Math.round(newX + newWidth), Math.round(newY + newHeight));
    }

    @Override
    public void onLayoutUpdate(int x, int y, int width, int height) {
        this.calculateAnimation(x, y, width, height);
    }

    public boolean willChangeBounds() {
        return true;
    }

    private void calculateAnimation(int x, int y, int width, int height) {
        this.mStartX = this.mView.getX() - this.mView.getTranslationX();
        this.mStartY = this.mView.getY() - this.mView.getTranslationY();
        this.mStartWidth = this.mView.getWidth();
        this.mStartHeight = this.mView.getHeight();
        this.mDeltaX = (float)x - this.mStartX;
        this.mDeltaY = (float)y - this.mStartY;
        this.mDeltaWidth = width - this.mStartWidth;
        this.mDeltaHeight = height - this.mStartHeight;
    }
}

