/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.NativeAnimatedNodesManager;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.JavaOnlyArray;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import java.util.ArrayList;
import java.util.List;

class TransformAnimatedNode
extends AnimatedNode {
    private final NativeAnimatedNodesManager mNativeAnimatedNodesManager;
    private final List<TransformConfig> mTransformConfigs;

    TransformAnimatedNode(ReadableMap config, NativeAnimatedNodesManager nativeAnimatedNodesManager) {
        ReadableArray transforms = config.getArray("transforms");
        this.mTransformConfigs = new ArrayList<TransformConfig>(transforms.size());
        for (int i = 0; i < transforms.size(); ++i) {
            TransformConfig transformConfig;
            ReadableMap transformConfigMap = transforms.getMap(i);
            String property = transformConfigMap.getString("property");
            String type = transformConfigMap.getString("type");
            if (type.equals("animated")) {
                transformConfig = new AnimatedTransformConfig();
                transformConfig.mProperty = property;
                transformConfig.mNodeTag = transformConfigMap.getInt("nodeTag");
                this.mTransformConfigs.add(transformConfig);
                continue;
            }
            transformConfig = new StaticTransformConfig();
            ((StaticTransformConfig)transformConfig).mProperty = property;
            ((StaticTransformConfig)transformConfig).mValue = transformConfigMap.getDouble("value");
            this.mTransformConfigs.add(transformConfig);
        }
        this.mNativeAnimatedNodesManager = nativeAnimatedNodesManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void collectViewUpdates(JavaOnlyMap propsMap) {
        ArrayList<JavaOnlyMap> transforms = new ArrayList<JavaOnlyMap>(this.mTransformConfigs.size());
        for (TransformConfig transformConfig : this.mTransformConfigs) {
            double value;
            if (transformConfig instanceof AnimatedTransformConfig) {
                int nodeTag = ((AnimatedTransformConfig)transformConfig).mNodeTag;
                AnimatedNode node = this.mNativeAnimatedNodesManager.getNodeById(nodeTag);
                if (node == null) {
                    throw new IllegalArgumentException("Mapped style node does not exists");
                }
                if (!(node instanceof ValueAnimatedNode)) throw new IllegalArgumentException("Unsupported type of node used as a transform child node " + node.getClass());
                value = ((ValueAnimatedNode)node).getValue();
            } else {
                value = ((StaticTransformConfig)transformConfig).mValue;
            }
            transforms.add(JavaOnlyMap.of(transformConfig.mProperty, value));
        }
        propsMap.putArray("transform", JavaOnlyArray.from(transforms));
    }

    private class StaticTransformConfig
    extends TransformConfig {
        public double mValue;

        private StaticTransformConfig() {
        }
    }

    private class AnimatedTransformConfig
    extends TransformConfig {
        public int mNodeTag;

        private AnimatedTransformConfig() {
        }
    }

    private class TransformConfig {
        public String mProperty;

        private TransformConfig() {
        }
    }
}

