/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.dialog;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.util.Log;
import com.facebook.react.modules.dialog.AlertFragment;
import com.facebook.react.modules.dialog.DialogModule;
import javax.annotation.Nullable;

public class SupportAlertFragment
extends DialogFragment
implements DialogInterface.OnClickListener {
    @Nullable
    private final DialogModule.AlertFragmentListener mListener;

    public SupportAlertFragment() {
        this.mListener = null;
    }

    @SuppressLint(value={"ValidFragment"})
    public SupportAlertFragment(@Nullable DialogModule.AlertFragmentListener listener, Bundle arguments) {
        this.mListener = listener;
        this.setArguments(arguments);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        final Dialog dialog = AlertFragment.createDialog((Context)this.getActivity(), this.getArguments(), this);
        dialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface d) {
                Log.i((String)"myyf", (String)"show");
                dialog.getWindow().setFlags(8, 8);
                if (Build.VERSION.SDK_INT >= 19) {
                    int uiOptions = 5894;
                    dialog.getWindow().getDecorView().setSystemUiVisibility(uiOptions);
                } else if (Build.VERSION.SDK_INT > 11 && Build.VERSION.SDK_INT < 19) {
                    dialog.getWindow().getDecorView().setSystemUiVisibility(8);
                }
                dialog.getWindow().clearFlags(8);
            }
        });
        return dialog;
    }

    public void onClick(DialogInterface dialog, int which) {
        if (this.mListener != null) {
            this.mListener.onClick(dialog, which);
        }
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mListener != null) {
            this.mListener.onDismiss(dialog);
        }
    }
}

