/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import androidx.core.util.Pools;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.RCTEventEmitter;

public class OnLayoutEvent
extends Event<OnLayoutEvent> {
    private static final Pools.SynchronizedPool<OnLayoutEvent> EVENTS_POOL = new Pools.SynchronizedPool(20);
    private int mX;
    private int mY;
    private int mWidth;
    private int mHeight;

    public static OnLayoutEvent obtain(int viewTag, int x, int y, int width, int height) {
        OnLayoutEvent event = (OnLayoutEvent)EVENTS_POOL.acquire();
        if (event == null) {
            event = new OnLayoutEvent();
        }
        event.init(viewTag, x, y, width, height);
        return event;
    }

    @Override
    public void onDispose() {
        EVENTS_POOL.release((Object)this);
    }

    private OnLayoutEvent() {
    }

    protected void init(int viewTag, int x, int y, int width, int height) {
        super.init(viewTag);
        this.mX = x;
        this.mY = y;
        this.mWidth = width;
        this.mHeight = height;
    }

    @Override
    public String getEventName() {
        return "topLayout";
    }

    @Override
    public void dispatch(RCTEventEmitter rctEventEmitter) {
        WritableMap layout2 = Arguments.createMap();
        layout2.putDouble("x", PixelUtil.toDIPFromPixel(this.mX));
        layout2.putDouble("y", PixelUtil.toDIPFromPixel(this.mY));
        layout2.putDouble("width", PixelUtil.toDIPFromPixel(this.mWidth));
        layout2.putDouble("height", PixelUtil.toDIPFromPixel(this.mHeight));
        WritableMap event = Arguments.createMap();
        event.putMap("layout", layout2);
        event.putInt("target", this.getViewTag());
        rctEventEmitter.receiveEvent(this.getViewTag(), this.getEventName(), event);
    }
}

