/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.camera;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.graphics.BitmapFactory;
import android.media.MediaMetadataRetriever;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.GuardedAsyncTask;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.module.annotations.ReactModule;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import javax.annotation.Nullable;

@ReactModule(name="CameraRollManager")
public class CameraRollManager
extends ReactContextBaseJavaModule {
    public static final String NAME = "CameraRollManager";
    private static final String ERROR_UNABLE_TO_LOAD = "E_UNABLE_TO_LOAD";
    private static final String ERROR_UNABLE_TO_LOAD_PERMISSION = "E_UNABLE_TO_LOAD_PERMISSION";
    private static final String ERROR_UNABLE_TO_SAVE = "E_UNABLE_TO_SAVE";
    private static final String ERROR_UNABLE_TO_FILTER = "E_UNABLE_TO_FILTER";
    private static final String ASSET_TYPE_PHOTOS = "Photos";
    private static final String ASSET_TYPE_VIDEOS = "Videos";
    private static final String ASSET_TYPE_ALL = "All";
    private static final String[] PROJECTION = new String[]{"_id", "mime_type", "bucket_display_name", "datetaken", "width", "height", "longitude", "latitude", "_data"};
    private static final String SELECTION_BUCKET = "bucket_display_name = ?";
    private static final String SELECTION_DATE_TAKEN = "datetaken < ?";

    public CameraRollManager(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @ReactMethod
    public void saveToCameraRoll(String uri, String type, Promise promise) {
        new SaveToCameraRoll(this.getReactApplicationContext(), Uri.parse((String)uri), promise).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    @ReactMethod
    public void getPhotos(ReadableMap params, Promise promise) {
        ReadableArray mimeTypes;
        int first = params.getInt("first");
        String after = params.hasKey("after") ? params.getString("after") : null;
        String groupName = params.hasKey("groupName") ? params.getString("groupName") : null;
        String assetType = params.hasKey("assetType") ? params.getString("assetType") : ASSET_TYPE_PHOTOS;
        ReadableArray readableArray = mimeTypes = params.hasKey("mimeTypes") ? params.getArray("mimeTypes") : null;
        if (params.hasKey("groupTypes")) {
            throw new JSApplicationIllegalArgumentException("groupTypes is not supported on Android");
        }
        new GetMediaTask(this.getReactApplicationContext(), first, after, groupName, mimeTypes, assetType, promise).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    private static void putPageInfo(Cursor media, WritableMap response, int limit) {
        WritableNativeMap pageInfo = new WritableNativeMap();
        pageInfo.putBoolean("has_next_page", limit < media.getCount());
        if (limit < media.getCount()) {
            media.moveToPosition(limit - 1);
            pageInfo.putString("end_cursor", media.getString(media.getColumnIndex("datetaken")));
        }
        response.putMap("page_info", pageInfo);
    }

    private static void putEdges(ContentResolver resolver, Cursor media, WritableMap response, int limit) {
        WritableNativeArray edges = new WritableNativeArray();
        media.moveToFirst();
        int idIndex = media.getColumnIndex("_id");
        int mimeTypeIndex = media.getColumnIndex("mime_type");
        int groupNameIndex = media.getColumnIndex("bucket_display_name");
        int dateTakenIndex = media.getColumnIndex("datetaken");
        int widthIndex = media.getColumnIndex("width");
        int heightIndex = media.getColumnIndex("height");
        int longitudeIndex = media.getColumnIndex("longitude");
        int latitudeIndex = media.getColumnIndex("latitude");
        int dataIndex = media.getColumnIndex("_data");
        for (int i = 0; i < limit && !media.isAfterLast(); ++i) {
            WritableNativeMap edge = new WritableNativeMap();
            WritableNativeMap node = new WritableNativeMap();
            boolean imageInfoSuccess = CameraRollManager.putImageInfo(resolver, media, node, idIndex, widthIndex, heightIndex, dataIndex);
            if (imageInfoSuccess) {
                CameraRollManager.putBasicNodeInfo(media, node, mimeTypeIndex, groupNameIndex, dateTakenIndex);
                CameraRollManager.putLocationInfo(media, node, longitudeIndex, latitudeIndex);
                edge.putMap("node", node);
                edges.pushMap(edge);
            } else {
                --i;
            }
            media.moveToNext();
        }
        response.putArray("edges", edges);
    }

    private static void putBasicNodeInfo(Cursor media, WritableMap node, int mimeTypeIndex, int groupNameIndex, int dateTakenIndex) {
        node.putString("type", media.getString(mimeTypeIndex));
        node.putString("group_name", media.getString(groupNameIndex));
        node.putDouble("timestamp", (double)media.getLong(dateTakenIndex) / 1000.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean putImageInfo(ContentResolver resolver, Cursor media, WritableMap node, int idIndex, int widthIndex, int heightIndex, int dataIndex) {
        AssetFileDescriptor photoDescriptor;
        WritableNativeMap image = new WritableNativeMap();
        Uri photoUri = Uri.parse((String)("file://" + media.getString(dataIndex)));
        image.putString("uri", photoUri.toString());
        float width = media.getInt(widthIndex);
        float height = media.getInt(heightIndex);
        String mimeType = URLConnection.guessContentTypeFromName(photoUri.toString());
        if (mimeType != null && mimeType.startsWith("video")) {
            photoDescriptor = resolver.openAssetFileDescriptor(photoUri, "r");
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            retriever.setDataSource(photoDescriptor.getFileDescriptor());
            try {
                if (width <= 0.0f || height <= 0.0f) {
                    width = Integer.parseInt(retriever.extractMetadata(18));
                    height = Integer.parseInt(retriever.extractMetadata(19));
                }
                int timeInMillisec = Integer.parseInt(retriever.extractMetadata(9));
                int playableDuration = timeInMillisec / 1000;
                image.putInt("playableDuration", playableDuration);
            }
            catch (NumberFormatException e) {
                boolean bl;
                try {
                    FLog.e((String)"ReactNative", (String)("Number format exception occurred while trying to fetch video metadata for " + photoUri.toString()), (Throwable)e);
                    bl = false;
                }
                catch (Throwable throwable) {
                    try {
                        retriever.release();
                        photoDescriptor.close();
                        throw throwable;
                    }
                    catch (Exception e2) {
                        FLog.e((String)"ReactNative", (String)("Could not get video metadata for " + photoUri.toString()), (Throwable)e2);
                        return false;
                    }
                }
                retriever.release();
                photoDescriptor.close();
                return bl;
            }
            retriever.release();
            photoDescriptor.close();
        }
        if (width <= 0.0f || height <= 0.0f) {
            try {
                photoDescriptor = resolver.openAssetFileDescriptor(photoUri, "r");
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeFileDescriptor((FileDescriptor)photoDescriptor.getFileDescriptor(), null, (BitmapFactory.Options)options);
                width = options.outWidth;
                height = options.outHeight;
                photoDescriptor.close();
            }
            catch (IOException e) {
                FLog.e((String)"ReactNative", (String)("Could not get width/height for " + photoUri.toString()), (Throwable)e);
                return false;
            }
        }
        image.putDouble("width", width);
        image.putDouble("height", height);
        node.putMap("image", image);
        return true;
    }

    private static void putLocationInfo(Cursor media, WritableMap node, int longitudeIndex, int latitudeIndex) {
        double longitude = media.getDouble(longitudeIndex);
        double latitude = media.getDouble(latitudeIndex);
        if (longitude > 0.0 || latitude > 0.0) {
            WritableNativeMap location = new WritableNativeMap();
            location.putDouble("longitude", longitude);
            location.putDouble("latitude", latitude);
            node.putMap("location", location);
        }
    }

    private static class GetMediaTask
    extends GuardedAsyncTask<Void, Void> {
        private final Context mContext;
        private final int mFirst;
        @Nullable
        private final String mAfter;
        @Nullable
        private final String mGroupName;
        @Nullable
        private final ReadableArray mMimeTypes;
        private final Promise mPromise;
        private final String mAssetType;

        private GetMediaTask(ReactContext context, int first, @Nullable String after, @Nullable String groupName, @Nullable ReadableArray mimeTypes, String assetType, Promise promise) {
            super(context);
            this.mContext = context;
            this.mFirst = first;
            this.mAfter = after;
            this.mGroupName = groupName;
            this.mMimeTypes = mimeTypes;
            this.mPromise = promise;
            this.mAssetType = assetType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doInBackgroundGuarded(Void ... params) {
            block16: {
                StringBuilder selection = new StringBuilder("1");
                ArrayList<String> selectionArgs = new ArrayList<String>();
                if (!TextUtils.isEmpty((CharSequence)this.mAfter)) {
                    selection.append(" AND datetaken < ?");
                    selectionArgs.add(this.mAfter);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mGroupName)) {
                    selection.append(" AND bucket_display_name = ?");
                    selectionArgs.add(this.mGroupName);
                }
                if (this.mAssetType.equals(CameraRollManager.ASSET_TYPE_PHOTOS)) {
                    selection.append(" AND media_type = 1");
                } else if (this.mAssetType.equals(CameraRollManager.ASSET_TYPE_VIDEOS)) {
                    selection.append(" AND media_type = 3");
                } else if (this.mAssetType.equals(CameraRollManager.ASSET_TYPE_ALL)) {
                    selection.append(" AND media_type IN (3,1)");
                } else {
                    this.mPromise.reject(CameraRollManager.ERROR_UNABLE_TO_FILTER, "Invalid filter option: '" + this.mAssetType + "'. Expected one of '" + CameraRollManager.ASSET_TYPE_PHOTOS + "', '" + CameraRollManager.ASSET_TYPE_VIDEOS + "' or '" + CameraRollManager.ASSET_TYPE_ALL + "'.");
                    return;
                }
                if (this.mMimeTypes != null && this.mMimeTypes.size() > 0) {
                    selection.append(" AND mime_type IN (");
                    for (int i = 0; i < this.mMimeTypes.size(); ++i) {
                        selection.append("?,");
                        selectionArgs.add(this.mMimeTypes.getString(i));
                    }
                    selection.replace(selection.length() - 1, selection.length(), ")");
                }
                WritableNativeMap response = new WritableNativeMap();
                ContentResolver resolver = this.mContext.getContentResolver();
                try {
                    Cursor media = resolver.query(MediaStore.Files.getContentUri((String)"external"), PROJECTION, selection.toString(), selectionArgs.toArray(new String[selectionArgs.size()]), "datetaken DESC, date_modified DESC LIMIT " + (this.mFirst + 1));
                    if (media == null) {
                        this.mPromise.reject(CameraRollManager.ERROR_UNABLE_TO_LOAD, "Could not get media");
                        break block16;
                    }
                    try {
                        CameraRollManager.putEdges(resolver, media, response, this.mFirst);
                        CameraRollManager.putPageInfo(media, response, this.mFirst);
                    }
                    finally {
                        media.close();
                        this.mPromise.resolve(response);
                    }
                }
                catch (SecurityException e) {
                    this.mPromise.reject(CameraRollManager.ERROR_UNABLE_TO_LOAD_PERMISSION, "Could not get media: need READ_EXTERNAL_STORAGE permission", e);
                }
            }
        }
    }

    private static class SaveToCameraRoll
    extends GuardedAsyncTask<Void, Void> {
        private final Context mContext;
        private final Uri mUri;
        private final Promise mPromise;

        public SaveToCameraRoll(ReactContext context, Uri uri, Promise promise) {
            super(context);
            this.mContext = context;
            this.mUri = uri;
            this.mPromise = promise;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doInBackgroundGuarded(Void ... params) {
            File source = new File(this.mUri.getPath());
            AbstractInterruptibleChannel input = null;
            AbstractInterruptibleChannel output = null;
            try {
                String sourceExt;
                String sourceName;
                File exportDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
                exportDir.mkdirs();
                if (!exportDir.isDirectory()) {
                    this.mPromise.reject(CameraRollManager.ERROR_UNABLE_TO_LOAD, "External media storage directory not available");
                    return;
                }
                File dest = new File(exportDir, source.getName());
                int n = 0;
                String fullSourceName = source.getName();
                if (fullSourceName.indexOf(46) >= 0) {
                    sourceName = fullSourceName.substring(0, fullSourceName.lastIndexOf(46));
                    sourceExt = fullSourceName.substring(fullSourceName.lastIndexOf(46));
                } else {
                    sourceName = fullSourceName;
                    sourceExt = "";
                }
                while (!dest.createNewFile()) {
                    dest = new File(exportDir, sourceName + "_" + n++ + sourceExt);
                }
                input = new FileInputStream(source).getChannel();
                output = new FileOutputStream(dest).getChannel();
                ((FileChannel)output).transferFrom((ReadableByteChannel)((Object)input), 0L, ((FileChannel)input).size());
                input.close();
                output.close();
                MediaScannerConnection.scanFile((Context)this.mContext, (String[])new String[]{dest.getAbsolutePath()}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

                    public void onScanCompleted(String path, Uri uri) {
                        if (uri != null) {
                            mPromise.resolve(uri.toString());
                        } else {
                            mPromise.reject(CameraRollManager.ERROR_UNABLE_TO_SAVE, "Could not add image to gallery");
                        }
                    }
                });
            }
            catch (IOException e) {
                this.mPromise.reject(e);
            }
            finally {
                if (input != null && input.isOpen()) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        FLog.e((String)"ReactNative", (String)"Could not close input channel", (Throwable)e);
                    }
                }
                if (output != null && output.isOpen()) {
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        FLog.e((String)"ReactNative", (String)"Could not close output channel", (Throwable)e);
                    }
                }
            }
        }
    }
}

